/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public class DecorationUtil {
    private DecorationUtil() {
    }

    public static RGenericVector getGenericElement(RGenericVector model, String name) {
        try {
            return model.getGenericElement(name, true);
        }
        catch (IllegalArgumentException iae) {
            throw DecorationUtil.toDecorationException(model, name, iae);
        }
    }

    public static RBooleanVector getBooleanElement(RGenericVector model, String name) {
        try {
            return model.getBooleanElement(name, true);
        }
        catch (IllegalArgumentException iae) {
            throw DecorationUtil.toDecorationException(model, name, iae);
        }
    }

    public static RNumberVector<?> getNumericElement(RGenericVector model, String name) {
        try {
            return model.getNumericElement(name, true);
        }
        catch (IllegalArgumentException iae) {
            throw DecorationUtil.toDecorationException(model, name, iae);
        }
    }

    public static RVector<?> getVectorElement(RGenericVector model, String name) {
        try {
            return model.getVectorElement(name, true);
        }
        catch (IllegalArgumentException iae) {
            throw DecorationUtil.toDecorationException(model, name, iae);
        }
    }

    private static RuntimeException toDecorationException(RGenericVector model, String name, Exception e) {
        RStringVector classNames = model._class();
        String className = classNames.getValue(0);
        return new IllegalArgumentException("Missing '" + className + "$" + name + "' element. Please decorate the model object using the 'r2pmml::decorate." + className + "' function before saving it into the RDS file");
    }
}

