/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.ubjson;

import com.devsmart.ubjson.UBArray;
import com.devsmart.ubjson.UBString;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TreeMap;

public class UBReader
implements Closeable {
    private final InputStream mInputStream;

    public UBReader(InputStream in) {
        this.mInputStream = in;
    }

    @Override
    public void close() throws IOException {
        this.mInputStream.close();
    }

    private byte readControl() throws IOException {
        int value = this.mInputStream.read();
        if (value == -1) {
            throw new IOException("eof");
        }
        return (byte)value;
    }

    private byte readInt8() throws IOException {
        return this.readControl();
    }

    private short readUInt8() throws IOException {
        return (short)(0xFF & this.readControl());
    }

    private short readInt16() throws IOException {
        return (short)((this.readControl() & 0xFF) << 8 | this.readControl() & 0xFF);
    }

    private int readInt32() throws IOException {
        return (this.readControl() & 0xFF) << 24 | (this.readControl() & 0xFF) << 16 | (this.readControl() & 0xFF) << 8 | this.readControl() & 0xFF;
    }

    private long readInt64() throws IOException {
        return ((long)this.readControl() & 0xFFL) << 56 | ((long)this.readControl() & 0xFFL) << 48 | ((long)this.readControl() & 0xFFL) << 40 | ((long)this.readControl() & 0xFFL) << 32 | ((long)this.readControl() & 0xFFL) << 24 | ((long)this.readControl() & 0xFFL) << 16 | ((long)this.readControl() & 0xFFL) << 8 | (long)this.readControl() & 0xFFL;
    }

    private long readInt(byte control) throws IOException {
        long value;
        switch (control) {
            case 105: {
                value = this.readInt8();
                break;
            }
            case 85: {
                value = this.readUInt8();
                break;
            }
            case 73: {
                value = this.readInt16();
                break;
            }
            case 108: {
                value = this.readInt32();
                break;
            }
            case 76: {
                value = this.readInt64();
                break;
            }
            default: {
                throw new IOException("not an int type");
            }
        }
        return value;
    }

    private char readChar() throws IOException {
        char value = (char)this.readControl();
        return value;
    }

    private float readFloat32() throws IOException {
        int intvalue = (this.readControl() & 0xFF) << 24 | (this.readControl() & 0xFF) << 16 | (this.readControl() & 0xFF) << 8 | this.readControl() & 0xFF;
        float value = Float.intBitsToFloat(intvalue);
        return value;
    }

    private double readFloat64() throws IOException {
        long intvalue = ((long)this.readControl() & 0xFFL) << 56 | ((long)this.readControl() & 0xFFL) << 48 | ((long)this.readControl() & 0xFFL) << 40 | ((long)this.readControl() & 0xFFL) << 32 | ((long)this.readControl() & 0xFFL) << 24 | ((long)this.readControl() & 0xFFL) << 16 | ((long)this.readControl() & 0xFFL) << 8 | (long)this.readControl() & 0xFFL;
        double value = Double.longBitsToDouble(intvalue);
        return value;
    }

    private byte[] readString(byte control) throws IOException {
        int size = (int)this.readInt(control);
        byte[] value = new byte[size];
        int bytesLeft = size;
        int offset = 0;
        while (bytesLeft > 0) {
            int bytesRead = this.mInputStream.read(value, offset, size);
            if (bytesRead < 0) {
                throw new IOException("eof reached");
            }
            bytesLeft -= bytesRead;
            offset += bytesRead;
        }
        return value;
    }

    public void readData(OutputStream out) throws IOException {
        long len;
        int bytesRead;
        byte[] buf = new byte[4096];
        for (long bytesLeft = len = this.readInt(this.readControl()); bytesLeft > 0L; bytesLeft -= (long)bytesRead) {
            bytesRead = this.mInputStream.read(buf, 0, (int)Math.min((long)buf.length, bytesLeft));
            if (bytesRead < 0) {
                throw new IOException("stream too short");
            }
            out.write(buf, 0, bytesRead);
        }
    }

    private byte[] readOptimizedArrayInt8(int size) throws IOException {
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readInt8();
        }
        return data;
    }

    private short[] readOptimizedArrayInt16(int size) throws IOException {
        short[] data = new short[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readInt16();
        }
        return data;
    }

    private int[] readOptimizedArrayInt32(int size) throws IOException {
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readInt32();
        }
        return data;
    }

    private long[] readOptimizedArrayInt64(int size) throws IOException {
        long[] data = new long[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readInt64();
        }
        return data;
    }

    private float[] readOptimizedArrayFloat32(int size) throws IOException {
        float[] data = new float[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readFloat32();
        }
        return data;
    }

    private double[] readOptimizedArrayFloat64(int size) throws IOException {
        double[] data = new double[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readFloat64();
        }
        return data;
    }

    private String[] readOptimizedArrayString(int size) throws IOException {
        String[] data = new String[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new String(this.readString(this.readControl()), UBString.UTF_8);
        }
        return data;
    }

    private UBValue[] readOptimizedArray(int size, byte type) throws IOException {
        UBValue[] retval = new UBValue[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = this.readValue(type);
        }
        return retval;
    }

    private UBValue[] readOptimizedArray(int size) throws IOException {
        UBValue[] retval = new UBValue[size];
        for (int i = 0; i < size; ++i) {
            byte type = this.readControl();
            retval[i] = this.readValue(type);
        }
        return retval;
    }

    private UBArray readArray() throws IOException {
        byte control = this.readControl();
        if (control == 36) {
            byte type = this.readControl();
            if (this.readControl() != 35) {
                throw new IOException("optimized size missing");
            }
            int size = (int)this.readInt(this.readControl());
            switch (type) {
                case 105: {
                    return UBValueFactory.createArray(this.readOptimizedArrayInt8(size));
                }
                case 73: {
                    return UBValueFactory.createArray(this.readOptimizedArrayInt16(size));
                }
                case 108: {
                    return UBValueFactory.createArray(this.readOptimizedArrayInt32(size));
                }
                case 76: {
                    return UBValueFactory.createArray(this.readOptimizedArrayInt64(size));
                }
                case 100: {
                    return UBValueFactory.createArray(this.readOptimizedArrayFloat32(size));
                }
                case 68: {
                    return UBValueFactory.createArray(this.readOptimizedArrayFloat64(size));
                }
                case 83: {
                    return UBValueFactory.createArray(this.readOptimizedArrayString(size));
                }
            }
            return UBValueFactory.createArray(this.readOptimizedArray(size, type));
        }
        if (control == 35) {
            int size = (int)this.readInt(this.readControl());
            return UBValueFactory.createArray(this.readOptimizedArray(size));
        }
        ArrayList<UBValue> data = new ArrayList<UBValue>();
        while (control != 93) {
            data.add(this.readValue(control));
            control = this.readControl();
        }
        return UBValueFactory.createArray(data.toArray(new UBValue[data.size()]));
    }

    private UBValue readObj() throws IOException {
        TreeMap<String, UBValue> obj = new TreeMap<String, UBValue>();
        byte control = this.readControl();
        if (control == 36) {
            byte type = this.readControl();
            if (this.readControl() != 35) {
                throw new IOException("optimized size missing");
            }
            int size = (int)this.readInt(this.readControl());
            for (int i = 0; i < size; ++i) {
                String key = new String(this.readString(this.readControl()), UBString.UTF_8);
                UBValue value = this.readValue(type);
                obj.put(key, value);
            }
        } else if (control == 35) {
            int size = (int)this.readInt(this.readControl());
            for (int i = 0; i < size; ++i) {
                String key = new String(this.readString(this.readControl()), UBString.UTF_8);
                UBValue value = this.readValue(this.readControl());
                obj.put(key, value);
            }
        } else {
            while (control != 125) {
                String key = new String(this.readString(control), UBString.UTF_8);
                control = this.readControl();
                UBValue value = this.readValue(control);
                obj.put(key, value);
                control = this.readControl();
            }
        }
        return UBValueFactory.createObject(obj);
    }

    private UBValue readValue(byte control) throws IOException {
        UBValue retval = null;
        switch (control) {
            case 90: {
                retval = UBValueFactory.createNull();
                break;
            }
            case 84: {
                retval = UBValueFactory.createBool(true);
                break;
            }
            case 70: {
                retval = UBValueFactory.createBool(false);
                break;
            }
            case 67: {
                retval = UBValueFactory.createChar(this.readChar());
                break;
            }
            case 73: 
            case 76: 
            case 85: 
            case 105: 
            case 108: {
                retval = UBValueFactory.createInt(this.readInt(control));
                break;
            }
            case 100: {
                retval = UBValueFactory.createFloat32(this.readFloat32());
                break;
            }
            case 68: {
                retval = UBValueFactory.createFloat64(this.readFloat64());
                break;
            }
            case 83: {
                retval = UBValueFactory.createString(this.readString(this.readControl()));
                break;
            }
            case 91: {
                retval = this.readArray();
                break;
            }
            case 123: {
                retval = this.readObj();
            }
        }
        return retval;
    }

    public UBValue read() throws IOException {
        byte control = this.readControl();
        return this.readValue(control);
    }
}

