/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.leipzig;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EncodingParameter;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.leipzig.LeipzigLanguageSampleStream;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.ObjectStream;

public class LeipzigLanguageSampleStreamFactory
extends AbstractSampleStreamFactory<LanguageSample> {
    protected <P> LeipzigLanguageSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(LanguageSample.class, "leipzig", new LeipzigLanguageSampleStreamFactory(Parameters.class));
    }

    @Override
    public ObjectStream<LanguageSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        File sentencesFileDir = params.getSentencesDir();
        try {
            return new LeipzigLanguageSampleStream(sentencesFileDir, Integer.parseInt(params.getSentencesPerSample()), Integer.parseInt(params.getSamplesPerLanguage()));
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while opening sample data.", e);
        }
    }

    static interface Parameters
    extends EncodingParameter {
        @ArgumentParser.ParameterDescription(valueName="sentencesDir", description="dir with Leipig sentences to be used")
        public File getSentencesDir();

        @ArgumentParser.ParameterDescription(valueName="sentencesPerSample", description="number of sentences per sample")
        public String getSentencesPerSample();

        @ArgumentParser.ParameterDescription(valueName="samplesPerLanguage", description="number of samples per language")
        public String getSamplesPerLanguage();
    }
}

