/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.gann;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import keel.Algorithms.Neural_Networks.gann.ConnNetwork;
import keel.Algorithms.Neural_Networks.gann.Data;
import keel.Algorithms.Neural_Networks.gann.Genesis;
import keel.Algorithms.Neural_Networks.gann.Individual;
import keel.Algorithms.Neural_Networks.gann.OpenDataset;
import keel.Algorithms.Neural_Networks.gann.Parameters;
import keel.Algorithms.Neural_Networks.gann.Population;
import keel.Algorithms.Neural_Networks.gann.SetupParameters;

public class Gann {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length <= 0) {
            System.err.println("No parameters file");
            System.exit(1);
        }
        SetupParameters global = new SetupParameters();
        global.LoadParameters(args[0]);
        OpenDataset train = new OpenDataset();
        train.processClassifierDataset(global.train_file, true);
        OpenDataset test = null;
        OpenDataset validation = null;
        global.n_train_patterns = train.getndatos();
        global.n_test_patterns = 0;
        if (global.test_data) {
            test = new OpenDataset();
            test.processClassifierDataset(global.test_file, false);
            global.n_test_patterns = test.getndatos();
        }
        global.n_val_patterns = 0;
        if (global.val_data) {
            validation = new OpenDataset();
            validation.processClassifierDataset(global.val_file, false);
            global.n_val_patterns = validation.getndatos();
        }
        global.Ninputs = 0;
        for (int i = 0; i < train.getnentradas(); ++i) {
            if (train.getTiposAt(i) == 0) {
                Vector in_values = train.getRangosVar(i);
                global.Ninputs += in_values.size();
                continue;
            }
            ++global.Ninputs;
        }
        if (train.getTiposAt(train.getnentradas()) != 0) {
            global.Noutputs = train.getnsalidas();
        } else {
            Vector out_values = train.getRangosVar(train.getnentradas());
            global.Noutputs = out_values.size();
        }
        global.n_train_patterns = train.getndatos();
        Data data = new Data(global.Ninputs + global.Noutputs, global.n_train_patterns, global.n_test_patterns, global.n_val_patterns);
        global.Nhidden[global.Nhidden_layers] = global.Noutputs;
        Genesis.DatasetToArray(data.train, train);
        if (global.test_data) {
            Genesis.DatasetToArray(data.test, test);
        }
        if (global.val_data) {
            Genesis.DatasetToArray(data.validation, validation);
        }
        if (global.tipify_inputs) {
            for (int i = 0; i < global.Ninputs; ++i) {
                int j;
                double sq_sum = 0.0;
                double sigma = 0.0;
                double mean = 0.0;
                for (j = 0; j < global.n_train_patterns; ++j) {
                    mean += data.train[j][i];
                    sq_sum += data.train[j][i] * data.train[j][i];
                }
                if (!((sigma = Math.sqrt(sq_sum / (double)global.n_train_patterns - (mean /= (double)global.n_train_patterns) * mean)) > 1.0E-6)) continue;
                for (j = 0; j < global.n_train_patterns; ++j) {
                    data.train[j][i] = (data.train[j][i] - mean) / sigma;
                }
                for (j = 0; j < global.n_test_patterns; ++j) {
                    data.test[j][i] = (data.test[j][i] - mean) / sigma;
                }
            }
        }
        if (global.problem.compareToIgnoreCase("Classification") == 0) {
            int j;
            int i;
            for (i = 0; i < global.n_train_patterns; ++i) {
                for (j = 0; j < global.Noutputs; ++j) {
                    if (data.train[i][j + global.Ninputs] != 0.0) continue;
                    data.train[i][j + global.Ninputs] = -1.0;
                }
            }
            if (global.test_data) {
                for (i = 0; i < global.n_test_patterns; ++i) {
                    for (j = 0; j < global.Noutputs; ++j) {
                        if (data.test[i][j + global.Ninputs] != 0.0) continue;
                        data.test[i][j + global.Ninputs] = -1.0;
                    }
                }
            }
            if (global.val_data) {
                for (i = 0; i < global.n_val_patterns; ++i) {
                    for (j = 0; j < global.Noutputs; ++j) {
                        if (data.validation[i][j + global.Ninputs] != 0.0) continue;
                        data.validation[i][j + global.Ninputs] = -1.0;
                    }
                }
            }
        }
        Population pop = new Population(global);
        Individual best = new Individual(10);
        best = pop.EvolvePopulation(global, data);
        ConnNetwork neural = new ConnNetwork((Parameters)global);
        best.PhenotypeToNetwork(neural);
        if (global.save) {
            neural.SaveNetwork("network", false);
        }
        double res = neural.TestNetworkInClassification(global, data.train, global.n_train_patterns);
        System.out.println("Final network training accuracy: " + 100.0 * res);
        if (global.val_data) {
            res = neural.TestNetworkInClassification(global, data.validation, global.n_val_patterns);
            System.out.println("Final network validation accuracy: " + 100.0 * res);
        }
        if (global.test_data) {
            res = neural.TestNetworkInClassification(global, data.test, global.n_test_patterns);
            System.out.println("Final network test accuracy: " + 100.0 * res);
        }
        neural.SaveOutputFile(global.train_output, data.train, global.n_train_patterns, global.problem);
        if (global.test_data) {
            neural.SaveOutputFile(global.test_output, data.test, global.n_test_patterns, global.problem);
        }
    }
}

