/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class DuplicatedParameter
extends Parameter.Abstract
implements VariableListener {
    private final Parameter parameter;
    private Parameter dupParameter;
    private int copies;
    private Bounds<Double> bounds;
    private final Bounds<Double> originalBounds;

    public DuplicatedParameter(Parameter parameter) {
        this.parameter = parameter;
        parameter.addVariableListener(this);
        this.copies = 1;
        this.originalBounds = parameter.getBounds();
        this.bounds = this.originalBounds;
    }

    public void addDuplicationParameter(Parameter parameter) {
        this.dupParameter = parameter;
        parameter.addParameterListener(this);
        this.updateDuplication();
    }

    private void updateDuplication() {
        int n;
        this.copies = (int)this.dupParameter.getParameterValue(0);
        int n2 = this.originalBounds.getBoundsDimension();
        double[] dArray = new double[this.getDimension()];
        double[] dArray2 = new double[this.getDimension()];
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.originalBounds.getLowerLimit(n);
            dArray2[n] = this.originalBounds.getUpperLimit(n);
        }
        for (n = 1; n < this.copies; ++n) {
            System.arraycopy(dArray, 0, dArray, n * n2, n2);
            System.arraycopy(dArray2, 0, dArray2, n * n2, n2);
        }
        this.bounds = new Parameter.DefaultBounds(dArray2, dArray);
    }

    @Override
    public int getDimension() {
        return this.parameter.getDimension() * this.copies;
    }

    @Override
    protected void storeValues() {
        this.parameter.storeParameterValues();
    }

    @Override
    protected void restoreValues() {
        this.parameter.restoreParameterValues();
    }

    @Override
    protected void acceptValues() {
        this.parameter.acceptParameterValues();
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        this.parameter.adoptParameterValues(parameter);
    }

    @Override
    public double getParameterValue(int n) {
        return this.parameter.getParameterValue(n % this.parameter.getDimension());
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.parameter.setParameterValue(n % this.parameter.getDimension(), d);
        this.fireParameterChangedEvent(n, Variable.ChangeType.VALUE_CHANGED);
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.parameter.setParameterValueQuietly(n % this.parameter.getDimension(), d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.parameter.setParameterValueNotifyChangedAll(n % this.parameter.getDimension(), d);
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            return "duplicated" + this.parameter.getParameterName();
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds bounds) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.dupParameter) {
            this.updateDuplication();
        }
        for (int i = 0; i < this.copies; ++i) {
            this.fireParameterChangedEvent(n + i * this.parameter.getDimension(), Variable.ChangeType.VALUE_CHANGED);
        }
    }
}

