/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.util.HashMap;
import java.util.Vector;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RList;

public class REXPGenericVector
extends REXPVector {
    private RList payload;

    public REXPGenericVector(RList list) {
        RList rList = this.payload = list == null ? new RList() : list;
        if (this.payload.isNamed()) {
            this.attr = new REXPList(new RList(new REXP[]{new REXPString(this.payload.keys())}, new String[]{"names"}));
        }
    }

    public REXPGenericVector(RList list, REXPList attr) {
        super(attr);
        this.payload = list == null ? new RList() : list;
    }

    @Override
    public Object asNativeJavaObject() throws REXPMismatchException {
        String[] names;
        int n = this.payload.size();
        if (this.payload.isNamed() && (names = this.payload.keys()).length == n) {
            HashMap map = new HashMap();
            boolean valid = true;
            for (int i = 0; i < n; ++i) {
                if (map.containsKey(names[i])) {
                    valid = false;
                    break;
                }
                Object value = this.payload.elementAt(i);
                if (value != null) {
                    value = ((REXP)value).asNativeJavaObject();
                }
                map.put(names[i], value);
            }
            if (valid) {
                return map;
            }
        }
        Vector v = new Vector();
        for (int i = 0; i < n; ++i) {
            Object value = this.payload.elementAt(i);
            if (value != null) {
                value = ((REXP)value).asNativeJavaObject();
            }
            v.addElement(value);
        }
        return v;
    }

    @Override
    public int length() {
        return this.payload.size();
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    public RList asList() {
        return this.payload;
    }

    @Override
    public String toString() {
        return super.toString() + (this.asList().isNamed() ? "named" : "");
    }

    @Override
    public String toDebugString() {
        int i;
        StringBuffer sb = new StringBuffer(super.toDebugString() + "{");
        for (i = 0; i < this.payload.size() && i < maxDebugItems; ++i) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(this.payload.at(i).toDebugString());
        }
        if (i < this.payload.size()) {
            sb.append(",..");
        }
        return sb.toString() + "}";
    }
}

