/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.Lattice;
import dr.geo.Location;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class IslandLattice
extends JComponent
implements Lattice {
    private int[][] lattice;
    private final int width;
    private final int height;

    public IslandLattice(int n, int n2) {
        this.lattice = new int[n][n2];
        this.width = n;
        this.height = n2;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void paintLattice(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.green);
        for (int i = 0; i < this.lattice.length; ++i) {
            for (int j = 0; j < this.lattice.length; ++j) {
                if (this.lattice[i][j] <= 0) continue;
                graphics.drawRect(i, j, 1, 1);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.paintLattice(graphics);
    }

    @Override
    public final int latticeWidth() {
        return this.width;
    }

    @Override
    public final int latticeHeight() {
        return this.height;
    }

    public void setState(int n, int n2, int n3) {
        this.lattice[n][n2] = n3;
    }

    @Override
    public int getState(int n, int n2) {
        return this.lattice[n][n2];
    }

    public int getState(Location location) {
        return this.lattice[location.i][location.j];
    }

    public void smooth(int n) {
        int[][] nArray = new int[this.width][this.height];
        for (int i = 0; i < this.lattice.length; ++i) {
            for (int j = 0; j < this.lattice.length; ++j) {
                int n2 = this.getNeighbourSum(i, j);
                nArray[i][j] = n2 > n ? 1 : 0;
            }
        }
        this.lattice = nArray;
    }

    public List<Location> addIslands(int n, Random random) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = random.nextInt(this.width);
            if (this.getState(n3, n2 = random.nextInt(this.height)) != 0) continue;
            this.setState(n3, n2, 1);
            if (this.getNeighbourSum(n3, n2) != 0) continue;
            arrayList.add(new Location(n3, n2));
        }
        return arrayList;
    }

    public int growIslands(int n, Random random) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5 = random.nextInt(this.width);
            if (this.getState(n5, n4 = random.nextInt(this.height)) == 0 && this.getNeighbourSum(n5, n4) > 0) {
                this.setState(n5, n4, 1);
                ++n2;
            }
            ++n3;
        }
        return n3;
    }

    public int sum() {
        int n = 0;
        for (int i = 0; i < this.lattice.length; ++i) {
            for (int j = 0; j < this.lattice.length; ++j) {
                n += this.lattice[i][j];
            }
        }
        return n;
    }

    int getNeighbourSum(int n, int n2) {
        int n3 = 0;
        if (n > 0) {
            n3 += this.getState(n - 1, n2);
        }
        if (n < this.width - 1) {
            n3 += this.getState(n + 1, n2);
        }
        if (n2 > 0) {
            n3 += this.getState(n, n2 - 1);
        }
        if (n2 < this.height - 1) {
            n3 += this.getState(n, n2 + 1);
        }
        return n3;
    }

    private List<Location> getNeighbours(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (location.i > 0) {
            arrayList.add(new Location(location.i - 1, location.j));
        }
        if (location.i < this.width - 1) {
            arrayList.add(new Location(location.i + 1, location.j));
        }
        if (location.j > 0) {
            arrayList.add(new Location(location.i, location.j - 1));
        }
        if (location.j < this.height - 1) {
            arrayList.add(new Location(location.i, location.j + 1));
        }
        return arrayList;
    }

    private Set<Location> getEmptyNeighboursOfIsland(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        HashSet<Location> hashSet = new HashSet<Location>();
        HashSet<Location> hashSet2 = new HashSet<Location>();
        arrayList.add(location);
        while (arrayList.size() > 0) {
            Location location2 = (Location)arrayList.remove(arrayList.size() - 1);
            List<Location> list = this.getNeighbours(location2);
            for (Location location3 : list) {
                if (this.getState(location3) == 0) {
                    hashSet2.add(location3);
                    continue;
                }
                if (hashSet.contains(location3)) continue;
                arrayList.add(location3);
            }
            hashSet.add(location2);
        }
        return hashSet2;
    }

    public static void main(String[] stringArray) {
        Random random = new Random();
        IslandLattice islandLattice = new IslandLattice(500, 500);
        List<Location> list = islandLattice.addIslands(50, random);
        System.out.println("Created " + list.size() + " islands");
        int n = 4950;
        int n2 = islandLattice.growIslands(n, random);
        System.out.println("Took " + n2 + " attempts to grow islands by " + n);
        islandLattice.smooth(2);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)islandLattice, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

