/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocationScaleJeffreysPrior
extends AbstractModelLikelihood {
    private final Parameter location;
    private final Parameter sigma;
    private final Parameter gamma;
    private final Parameter alpha0;
    private final Parameter beta0;
    private final Type type;

    public LocationScaleJeffreysPrior(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Type type) {
        super("RubioSteele");
        this.location = parameter;
        this.sigma = parameter2;
        this.gamma = parameter3;
        this.alpha0 = parameter4;
        this.beta0 = parameter5;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addVariable(parameter3);
        if (parameter4 != null) {
            this.addVariable(parameter4);
        }
        if (parameter5 != null) {
            this.addVariable(parameter5);
        }
        this.type = type;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double d = this.alpha0 != null ? this.alpha0.getParameterValue(0) : 0.0;
        double d2 = this.beta0 != null ? this.beta0.getParameterValue(0) : 0.0;
        return this.type.logPdf(this.location.getParameterValue(0), this.sigma.getParameterValue(0), this.gamma.getParameterValue(0), d, d2);
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void storeState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    public static enum Type implements Compute
    {
        ISF_AG_BETA("inverseScaleFactorsAGBeta", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                return -Math.log(d2) + (2.0 * d4 - 1.0) * Math.log(d3) - (d4 + d5) * Math.log(1.0 + d3 * d3);
            }
        }),
        EPSILON_SKEW_AG_BETA("epsilonSkewAGBeta", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                return -Math.log(d2) + (d5 - 1.0) * Math.log(1.0 - d3) + (d4 - 1.0) * Math.log(1.0 + d3);
            }
        }),
        LOGISTIC_AG_BETA("logisticAGBeta", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                return -Math.log(d2) + d4 * Math.log(1.0 + Math.exp(2.0 * d3)) + d5 * Math.log(1.0 + Math.exp(-2.0 * d3)) - (d4 + d5) * Math.log(1.0 + Math.cosh(2.0 * d3));
            }
        }),
        TWO_SCALE("twoScale", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                return -(Math.log(d2) + Math.log(d3) + Math.log(d2 + d3));
            }
        }),
        TWO_SCALE_INDEPENDENT("twoScaleIndependent", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                throw new RuntimeException("Not yet implemented");
            }
        }),
        EPSILON_SKEW("epsilonSkew", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                return -2.0 * Math.log(d2) - Math.log(1.0 - d3 * d3);
            }
        }),
        EPSILON_SKEW_INDEPENDENT("epsilonSkewIndependent", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                return -Math.log(d2) - 0.5 * Math.log(1.0 - d3 * d3);
            }
        }),
        TWO_SCALE2("twoScale", new Compute(){

            @Override
            public double logPdf(double d, double d2, double d3, double d4, double d5) {
                return -(Math.log(d2) + Math.log(d3) + Math.log(d2 + d3));
            }
        });

        private final String text;
        private final Compute compute;

        private Type(String string2, Compute compute) {
            this.text = string2;
            this.compute = compute;
        }

        public static Type parseFromString(String string) {
            for (Type type : Type.values()) {
                if (type.toString().compareToIgnoreCase(string) != 0) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.text;
        }

        @Override
        public double logPdf(double d, double d2, double d3, double d4, double d5) {
            return this.compute.logPdf(d, d2, d3, d4, d5);
        }
    }

    private static interface Compute {
        public double logPdf(double var1, double var3, double var5, double var7, double var9);
    }
}

