######################################################################
# Analysis for project xyz
######################################################################

#  Design:
#  Response variable:
#  Structural Component:
#  Explanatory component:
#  Experimental Unit:
#  Observational Unit:
#  Residual:

# Load required packages
library(tidyverse)
library(biometryassist)
library(asreml)

# Read in data
dat <- read.csv("your_data_here.csv")

# Check data structure
str(dat)

# Change the required columns to factors for analysis
# Structural columns (row, column, block etc) and treatment columns should be factors
dat <- dat %>% mutate(across(c(1:7), factor))

# fitting the model
dat <- dat %>% arrange(Column, Row)
dat.asr <- asreml(Yield ~ Genotype + Nitrogen + Genotype:Nitrogen,
                  random = ~ Block + Block:WholePlot,
                  residual = ~ id(Column):ar1(Row), data = dat)
dat.ww <- wald(dat.asr, denDF = "default")$Wald
resplot(dat.asr)
round(dat.ww,3)

variogram(dat.asr)


summary(dat.asr)$varcomp
# Likelihood Ratio test
logl.tab <- logl_test(model.obj = dat.asr,
                      rand.terms = NULL,
                      resid.terms = c("ar1(Row)"))
logl.tab
# Prediction
pred.out <- multiple_comparisons(model.obj = dat.asr, classify = "Genotype")
pred.out

# graph the predicted values
autoplot(pred.out) +
    labs(x = "Genotype", y = "Predicted Yield (number of 1/4 lbs)")


# Prediction
pred.out <- multiple_comparisons(model.obj = dat.asr, classify = "Nitrogen")
pred.out

# graph the predicted values
autoplot(pred.out) +
    labs(x = "Nitrogen", y = "Predicted Yield (number of 1/4 lbs)")
