% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{MLEPO}
\alias{MLEPO}
\title{Proportional Odds (PO) model.}
\usage{
MLEPO(
  init,
  times,
  status,
  n,
  basehaz,
  z,
  method = "BFGS",
  hessian = TRUE,
  conf.int = 0.95,
  maxit = 1000,
  log = FALSE
)
}
\arguments{
\item{init}{: initial points for optimisation}

\item{times}{: survival times}

\item{status}{: vital status (1 - dead, 0 - alive)}

\item{n}{: The number of the data set}

\item{basehaz}{: baseline hazard structure including baseline (New generalized log-logistic proportional odds "NGLLPO" model,  generalized log-logisitic proportional odds "GLLPO" model, modified log-logistic proportional odds "MLLPO" model,
exponentiated Weibull proportional odds "EWPO" model, power generalized weibull proportional odds "PGWPO" model, generalized gamma proportional odds "GGPO" model,
modified kumaraswamy Weibull proportional odds "MKWPO" model, log-logistic proportional odds "PO" model,
tangent-log-logistic proportional odds "TLLPO" model, sine-log-logistic proportional odds "SLLPO" model, cosine log-logistic proportional odds "CLLPO" model,
secant-log-logistic proportional odds "SCLLPO" model, arcsine-log-logistic proportional odds "ASLLPO" model, and arctangent-log-logistic proportional odds "ATLLPO" model,
Weibull proportional odds "WPO" model, gamma proportional odds "GPO" model, and log-normal proportional odds "LNPO" model.)}

\item{z}{: design matrix for covariates (p x n), p >= 1}

\item{method}{:"optim" or a method from "nlminb".The methods supported are: BFGS (default), "L-BFGS", "Nelder-Mead", "SANN", "CG", and "Brent".}

\item{hessian}{:A function to return (as a matrix) the hessian for those methods that can use this information.}

\item{conf.int}{: confidence level}

\item{maxit}{:The maximum number of iterations. Defaults to 1000}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
a list containing the output of the optimisation (OPT) and the log-likelihood function (loglik)
}
\description{
Tractable Parametric Proportional Odds (PO) model's maximum likelihood estimation, log-likelihood, and information criterion.
 Baseline hazards: NGLL,GLL,MLL,PGW, GG, EW, MKW, LL, TLL, SLL,CLL,SCLL,ATLL, and ASLL
}
\examples{

#Example #1
data(alloauto)
time<-alloauto$time
delta<-alloauto$delta
z<-alloauto$type
MLEPO(init = c(1.0,0.40,1.0,0.50),times = time,status = delta,n=nrow(z),
basehaz = "GLLPO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

#Example #2
data(bmt)
time<-bmt$Time
delta<-bmt$Status
z<-bmt$TRT
MLEPO(init = c(1.0,1.0,0.5),times = time,status = delta,n=nrow(z),
basehaz = "SLLPO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

#Example #3
data("gastric")
time<-gastric$time
delta<-gastric$status
z<-gastric$trt
MLEPO(init = c(1.0,0.50,1.0,0.75),times = time,status = delta,n=nrow(z),
basehaz = "PGWPO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,
log=FALSE)

#Example #4
data("larynx")
time<-larynx$time
delta<-larynx$delta
larynx$age<-as.numeric(scale(larynx$age))
larynx$diagyr<-as.numeric(scale(larynx$diagyr))
larynx$stage<-as.factor(larynx$stage)
z<-model.matrix(~ stage+age+diagyr, data = larynx)
MLEPO(init = c(1.0,1.0,0.5,0.5,0.5,0.5,0.5,0.5),times = time,status = delta,n=nrow(z),
basehaz = "ATLLPO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Christophe Chesneau  \email{abdisalam.hassan@amoud.edu.so}
}
