% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{sPGW}
\alias{sPGW}
\title{Power Generalised Weibull (PGW) survivor function.}
\usage{
sPGW(t, kappa, alpha, eta)
}
\arguments{
\item{t}{: positive argument}

\item{kappa}{: scale parameter}

\item{alpha}{: shape parameter}

\item{eta}{: shape parameter}
}
\value{
the value of the PGW survivor function
}
\description{
Power Generalised Weibull (PGW) survivor function.
}
\examples{
t=runif(10,min=0,max=1)
sPGW(t=t, kappa=0.5, alpha=1.5, eta=0.6)

}
\references{
Alvares, D., & Rubio, F. J. (2021). A tractable Bayesian joint model for longitudinal and survival data. Statistics in Medicine, 40(19), 4213-4229.
}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Christophe Chesneau  \email{abdisalam.hassan@amoud.edu.so}
}
