% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{compute_prob_predicted}
\alias{compute_prob_predicted}
\title{Internal function: Based on given labels and scores, compute average
predicted risks in given score intervals.}
\usage{
compute_prob_predicted(
  pred_score,
  link = "logit",
  max_score = 100,
  score_breaks = seq(from = 5, to = 70, by = 5)
)
}
\arguments{
\item{pred_score}{A \code{data.frame} with outcomes and final scores
generated from \code{\link{AutoScore_fine_tuning_Ordinal}}}

\item{link}{The link function used to model ordinal outcomes. Default is
\code{"logit"} for proportional odds model. Other options are
\code{"cloglog"} (proportional hazards model) and \code{"probit"}.}

\item{max_score}{Maximum attainable value of final scores.}

\item{score_breaks}{A vector of score breaks to group scores. The average
predicted risk will be reported for each score interval in the lookup
table. Users are advised to first visualise the predicted risk for all
attainable scores to determine \code{scores} (see
\code{\link{plot_predicted_risk}})}
}
\description{
Internal function: Based on given labels and scores, compute average
predicted risks in given score intervals.
}
