% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestforest.R
\name{BaggedBEST}
\alias{BaggedBEST}
\title{Performs Bootstrap Aggregating of BEST trees}
\usage{
BaggedBEST(Data, VA, NoT = 50, Size = 50)
}
\arguments{
\item{Data}{A data set (Data Frame): Can take on both numerical and categorical predictors. Last column of the data set must be the Repsonse Variable (Categorical Variables only)}

\item{VA}{Variable Availability structure}

\item{NoT}{Number of Trees in the bag}

\item{Size}{Minimal Number of Observation within a leaf needed for partitionning (default is 50)}
}
\value{
A list of BEST Objects
}
\description{
Performs Bootstrap Aggregating of BEST trees
}
\examples{
n <- 500
Data <- BESTree::Data[1:n,]
d <- ncol(Data)-1
VA <- ForgeVA(d,1,0,0,0)
Size <- 50
NoT <- 10
Fit <- BESTree::BaggedBEST(Data,VA,NoT,Size)
}
