% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Chipavg}
\alias{Chipavg}
\title{Measurements of the thickness of the oxide layer of manufactured integrated
circuits}
\format{
A data frame/tibble with 30 observations on three variables
\describe{ 
\item{wafer1}{thickness of the oxide layer for \code{wafer1}} 
\item{wafer2}{thickness of the oxide layer for \code{wafer2}}
\item{thickness}{average thickness of the oxide layer of the eight measurements
obtained from each set of two wafers} 
}
}
\source{
Yashchin, E. 1995. \dQuote{Likelihood Ratio Methods 
for Monitoring Parameters of a Nested Random Effect Model.} 
\emph{Journal of the American Statistical Association}, 90, 729-738.
}
\usage{
Chipavg
}
\description{
Data for Exercises 6.49 and 7.47
}
\examples{

EDA(Chipavg$thickness)
t.test(Chipavg$thickness, mu = 1000)
boxplot(Chipavg$wafer1, Chipavg$wafer2, name = c("Wafer 1", "Wafer 2"))
shapiro.test(Chipavg$wafer1)
shapiro.test(Chipavg$wafer2)
t.test(Chipavg$wafer1, Chipavg$wafer2, var.equal = TRUE)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
