/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.loggers;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.Logger;
import dr.inference.loggers.TabDelimitedFormatter;
import dr.util.Keywordable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MCLogger
implements Logger {
    private static final int PERFORMANCE_SAMPLE_SIZE = 100;
    private final boolean performanceReport;
    private final int performanceReportDelay;
    private String title = null;
    private Set<String> keywords = new HashSet<String>();
    private List<LogColumn> columns = new ArrayList<LogColumn>();
    protected long logEvery = 0L;
    protected List<LogFormatter> formatters = new ArrayList<LogFormatter>();
    private boolean performanceReportStarted = false;
    private long startTime;
    private long startState;
    private Deque<Long> rollingTime = new LinkedList<Long>();
    private Deque<Long> rollingState = new LinkedList<Long>();
    private final NumberFormat formatter = NumberFormat.getNumberInstance();

    public MCLogger(LogFormatter logFormatter, long l, boolean bl, int n) {
        this.addFormatter(logFormatter);
        this.logEvery = l;
        this.performanceReport = bl;
        this.performanceReportDelay = n;
    }

    public MCLogger(LogFormatter logFormatter, long l, boolean bl) {
        this(logFormatter, l, bl, 0);
    }

    public MCLogger(String string, long l, boolean bl, int n) throws IOException {
        this(new TabDelimitedFormatter(new PrintWriter(new FileWriter(string))), l, bl, n);
    }

    public MCLogger(boolean bl, int n) {
        this.performanceReport = bl;
        this.performanceReportDelay = n;
    }

    public MCLogger(long l) {
        this(new TabDelimitedFormatter(System.out), l, true, 0);
    }

    public final void setTitle(String string) {
        this.title = string;
    }

    public final String getTitle() {
        return this.title;
    }

    public long getLogEvery() {
        return this.logEvery;
    }

    public void setLogEvery(long l) {
        this.logEvery = l;
    }

    public final void addFormatter(LogFormatter logFormatter) {
        this.formatters.add(logFormatter);
    }

    public final void add(Loggable loggable) {
        LogColumn[] logColumnArray;
        for (LogColumn logColumn : logColumnArray = loggable.getColumns()) {
            this.addColumn(logColumn);
        }
    }

    public final void addColumn(LogColumn logColumn) {
        if (logColumn instanceof Keywordable) {
            this.keywords.addAll(((Keywordable)((Object)logColumn)).getKeywords());
        }
        this.columns.add(logColumn);
    }

    public final void addColumns(LogColumn[] logColumnArray) {
        for (LogColumn logColumn : logColumnArray) {
            this.addColumn(logColumn);
        }
    }

    public final int getColumnCount() {
        return this.columns.size();
    }

    public final LogColumn getColumn(int n) {
        return this.columns.get(n);
    }

    public final String getColumnLabel(int n) {
        return this.columns.get(n).getLabel();
    }

    public final String getColumnFormatted(int n) {
        return this.columns.get(n).getFormatted();
    }

    protected void logHeading(String string) {
        for (LogFormatter logFormatter : this.formatters) {
            logFormatter.logHeading(string);
        }
    }

    protected void logLine(String string) {
        for (LogFormatter logFormatter : this.formatters) {
            logFormatter.logLine(string);
        }
    }

    protected void logLabels(String[] stringArray) {
        for (LogFormatter logFormatter : this.formatters) {
            logFormatter.logLabels(stringArray);
        }
    }

    protected void logValues(String[] stringArray) {
        for (LogFormatter logFormatter : this.formatters) {
            logFormatter.logValues(stringArray);
        }
    }

    @Override
    public void startLogging() {
        for (LogFormatter stringArray : this.formatters) {
            stringArray.startLogging(this.title);
        }
        if (this.title != null) {
            this.logHeading(this.title);
        }
        if (this.keywords.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("keywords:");
            for (String string : this.keywords) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            this.logHeading(stringBuffer.toString());
        }
        if (this.logEvery > 0L) {
            int n = this.getColumnCount();
            String[] stringArray = new String[n + 1];
            stringArray[0] = "state";
            for (int i = 0; i < n; ++i) {
                stringArray[i + 1] = this.getColumnLabel(i);
            }
            this.logLabels(stringArray);
        }
    }

    public final void log(int n) {
    }

    @Override
    public void log(long l) {
        if (this.performanceReport && !this.performanceReportStarted && l >= (long)this.performanceReportDelay) {
            this.startTime = System.currentTimeMillis();
            this.startState = l;
            this.formatter.setMaximumFractionDigits(2);
        }
        if (this.logEvery > 0L && l % this.logEvery == 0L) {
            int n = this.getColumnCount();
            String[] stringArray = new String[n + (this.performanceReport ? 2 : 1)];
            stringArray[0] = Long.toString(l);
            for (int i = 0; i < n; ++i) {
                stringArray[i + 1] = this.getColumnFormatted(i);
            }
            if (this.performanceReport) {
                long l2 = System.currentTimeMillis();
                this.rollingTime.add(l2);
                if (this.rollingTime.size() > 100) {
                    this.rollingTime.removeFirst();
                }
                this.rollingState.add(l);
                if (this.rollingState.size() > 100) {
                    this.rollingState.removeFirst();
                }
                if (this.performanceReportStarted) {
                    double d = ((double)this.rollingTime.getLast().longValue() - (double)this.rollingTime.getFirst().longValue()) / (3.6 * (double)(this.rollingState.getLast() - this.rollingState.getFirst()));
                    String string = this.getTimePerMillion(d);
                    String string2 = this.getUnits(d);
                    stringArray[n + 1] = string + string2;
                } else {
                    stringArray[n + 1] = "-";
                }
            }
            this.logValues(stringArray);
        }
        if (this.performanceReport && !this.performanceReportStarted && l >= (long)this.performanceReportDelay) {
            this.performanceReportStarted = true;
        }
    }

    @Override
    public void stopLogging() {
        for (LogFormatter logFormatter : this.formatters) {
            logFormatter.stopLogging();
        }
    }

    public List<LogFormatter> getFormatters() {
        return this.formatters;
    }

    public void setFormatters(List<LogFormatter> list) {
        this.formatters = list;
    }

    public String getTimePerMillion(double d) {
        String string = this.formatter.format(d);
        if (d < 0.1) {
            double d2 = d * 60.0;
            string = this.formatter.format(d2);
            if (d2 < 0.1) {
                double d3 = d2 * 60.0;
                string = this.formatter.format(d3);
            }
        }
        return string;
    }

    public String getUnits(double d) {
        String string = " hours/million states";
        if (d < 0.1) {
            double d2 = d * 60.0;
            string = " minutes/million states";
            if (d2 < 0.1) {
                string = " seconds/million states";
            }
        }
        return string;
    }
}

