% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meme_plot.R
\name{meme_plot}
\alias{meme_plot}
\title{meme_plot}
\usage{
meme_plot(
  meme_file,
  the_order = NULL,
  motif_select = NULL,
  shape = "RoundRect",
  show_motif_id = FALSE,
  r = 0.3,
  legend_size = 15,
  motif_color = NULL
)
}
\arguments{
\item{meme_file}{The path of meme file or mast file.}

\item{the_order}{The path of order file. A List of Gene ID , One ID Per Line.}

\item{motif_select}{The motif ID which you want to align with.}

\item{shape}{RoundRect or Rect.}

\item{show_motif_id}{Display the name of the motif.}

\item{r}{The radius of rounded corners.}

\item{legend_size}{The size of legend.}

\item{motif_color}{The color set of motif.}
}
\value{
p
}
\description{
Visualization of motif in meme file or mast file
}
\examples{

mast_path <- system.file("extdata", "mast.xml", package = "BioVizSeq")
meme_plot(mast_path)

meme_plot(mast_path, motif_select="1", show_motif_id = TRUE)

order_path <- system.file("extdata", "order.csv", package = "BioVizSeq")
meme_plot(mast_path, the_order=order_path, motif_select="1")
}
\author{
Shiqi Zhao
}
