% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBTF-package.R
\docType{package}
\name{CBTF-package}
\alias{CBTF}
\alias{CBTF-package}
\title{CBTF: Caught by the Fuzz! A minimalistic fuzz-test runner}
\description{
This package implements a very simple mechanism for fuzz-testing functions
in the public interface of an R package.
}
\details{
Fuzz testing helps identify functions lacking sufficient argument validation,
and uncovers sets of inputs that, while valid by function signature, may
cause issues within the function body.

The core functionality of the package is in \link{fuzz}, which calls each
provided function with a certain input and records the output produced.
If an error or a warning is generated, this is captured and reported to the
user, unless it matches a pattern of whitelisted messages. The objects
returned by \link{fuzz} can be inspected with \link{summary.cbtf} and \link{print.cbtf}.

Whitelisting can also be done after a fuzz run has been completed via the
\link{whitelist} function, so that only messages that need to be acted upon are
actually shown. Using \link{whitelist} has the advantage of not requiring the
completion of a fuzz run of all functions over all inputs again.

The helper function \link{get_exported_functions} identifies the functions
in the public interface of a given package, facilitating the generation of
the list of functions to be fuzzed.

The helper function \link{test_inputs} is invoked by \link{fuzz} if the user doesn't
specify the set of inputs to be tested. By default generates a large set of
potentially problematic inputs, but these can be limited just to the
desired classes of inputs.

The helper function \link{namify} can be used to generate automatically pretty
names in the list of input object, which can improve the output, especially
when structures such as data frames, matrices, and more complex objects are
involved. These names are based on the deparsed representation of the
unevaluated inputs.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mcol.github.io/caught-by-the-fuzz/}
  \item Report bugs at \url{https://github.com/mcol/caught-by-the-fuzz/issues}
}

}
\author{
\strong{Maintainer}: Marco Colombo \email{mar.colombo13@gmail.com} (\href{https://orcid.org/0000-0001-6672-0623}{ORCID})

}
