% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLIC.R
\name{CLIC}
\alias{CLIC}
\title{CLIC function based on LIC with cosine_random distributed errors}
\usage{
CLIC(X, Y, alpha = 0.05, K = 10, nk = NULL, dist_type = "cosine_random")
}
\arguments{
\item{X}{is a design matrix}

\item{Y}{is a random response vector of observed values}

\item{alpha}{is the significance level}

\item{K}{is the number of subsets}

\item{nk}{is the sample size of subsets}

\item{dist_type}{is the type where the error term obeys a cosine_random distribution}
}
\value{
MUopt, Bopt, MAEMUopt, MSEMUopt, opt, Yopt
}
\description{
The CLIC function builds on the LIC function by introducing the assumption that the error term follows a cosine_random distribution, thereby enhancing the length and information optimisation criterion.
}
\examples{
set.seed(12)
n <- 1200
nr <- 200
p <- 5
data <- cerr(n, nr, p, dist_type = "cosine_random")
CLIC(data$X, data$Y, alpha = 0.05, K = 10, nk = n / 10, dist_type = "cosine_random")

}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}

Guo, G., Sun, Y., Qian, G., & Wang, Q. (2022). LIC criterion for optimal subset selection in distributed interval estimation. \emph{Journal of Applied Statistics}, 50(9), 1900-1920. \doi{10.1080/02664763.2022.2053949}.

Chang, D., Guo, G. (2024). LIC: An R package for optimal subset selection for distributed data. \emph{SoftwareX}, 28, 101909.

Jing, G., & Guo, G. (2025). TLIC: An R package for the LIC for T distribution regression analysis. \emph{SoftwareX}, 30, 102132.

Chang, D., & Guo, G. (2025). Research on Distributed Redundant Data Estimation Based on LIC. \emph{IAENG International Journal of Applied Mathematics}, 55(1), 1-6.

Gao, H., & Guo, G. (2025). LIC for Distributed Skewed Regression. \emph{IAENG International Journal of Applied Mathematics}, 55(9), 2925-2930.

Zhang, C., & Guo, G. (2025). The optimal subset estimation of distributed redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 270–277.

Jing, G., & Guo, G. (2025). Student LIC for distributed estimation. \emph{IAENG International Journal of Applied Mathematics}, 55(3), 575–581.

Liu, Q., & Guo, G. (2025). Distributed estimation of redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 332–337.
}
