% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityDataFrame.R
\name{densityDataFrame}
\alias{densityDataFrame}
\title{Convert to dataframe}
\usage{
densityDataFrame(densProfile, sampleID = "NoID", addTransitionType = FALSE)
}
\arguments{
\item{densProfile}{Density profile}

\item{sampleID}{Sample ID}

\item{addTransitionType}{add transition type to dataframe}
}
\value{
Dataframe with cambial age, density, years, transition type
}
\description{
Convert to dataframe
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

endPath <- c(472, 284) # manual
# not run - endPath <- locatePathEnd(im_dens, pith_coord) # using the image

path <- extractProfile(im_dens, image_info, pith_coord, endPath, k = 2, r = 5, threshold = 0.002)

pathEwLw <- getEwLw(path)
plotProfile(pathEwLw)
path_avgDens <- calcAvgDens(pathEwLw)
densityDf <- densityDataFrame(pathEwLw)

}
