% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageToMatrix.R
\name{imageToMatrix}
\alias{imageToMatrix}
\title{Convert dicom image to matrix}
\usage{
imageToMatrix(img)
}
\arguments{
\item{img}{Dicom image}
}
\value{
Matrix of image
}
\description{
Convert dicom image to matrix
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
dim(im)
image(im)

}
