% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.r
\name{bootstrap}
\alias{bootstrap}
\title{Executes an NLME Bootstrap}
\usage{
bootstrap(
  model,
  hostPlatform = NULL,
  params,
  bootParams,
  runInBackground = FALSE,
  ...
)
}
\arguments{
\item{model}{PK/PD model class object.}

\item{hostPlatform}{Host definition for model execution. See \code{\link{hostParams}}.
If \code{missing}, multicore local host with 4 threads is used.}

\item{params}{Engine parameters. See \code{\link{engineParams}}.
If \code{missing}, default parameters generated by engineParams(model) are used.}

\item{bootParams}{Bootstrap parameters. See \code{\link{BootstrapParams}}.
If \code{missing}, default parameters generated by BootstrapParams() are used.}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt.}

\item{...}{Additional class initializer arguments for \code{\link{BootstrapParams}} or
\code{\link{hostParams}}, or arguments available inside \code{\link{engineParams}} functions.
If \code{\link{engineParams}} arguments are supplied through both \code{params} argument
and additional argument (i.e., ellipsis), then the arguments in \code{params} will be ignored
and only the additional arguments will be used with warning.
If \code{\link{hostParams}} arguments are supplied through both \code{hostPlatform}
 argument and additional argument, then its values will be overridden by additional arguments.
 In addition, if \code{\link{BootstrapParams}} arguments are supplied through both
 \code{bootParams} argument and additional argument,
 then its slots will be overridden by additional arguments.}
}
\value{
if \code{runInBackground = FALSE}, a list is returned with bootstrap results, i.e.
"BootOverall", "BootTheta", "BootOmega", "BootOmegaStderr", "BootVarCoVar" comma separated files.
Otherwise the \code{BootNlmeJob} class object is returned.
}
\description{
Method to execute an NLME Bootstrap
}
\examples{
\dontrun{
input_data <- pkData

model <-
  pkmodel(
    numCompartments = 2,
    data = input_data,
    ID = "Subject",
    Time = "Act_Time",
    A1 = "Amount",
    CObs = "Conc",
    workingDir = tempdir()
  )

# multicore
multicoreHost <- hostParams(
  sharedDirectory = tempdir(),
  parallelMethod = "Multicore",
  hostName = "local_multicore",
  numCores = 4
)

bootstrapdf <- bootstrap(model,
  hostPlatform = multicoreHost,
  params = engineParams(model),
  numReplicates = 5,
  randomNumSeed = 1234,
  runInBackground = FALSE
)
}

}
\seealso{
\code{\link{hostParams}, \link{engineParams}, \link{BootstrapParams}}
}
