% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_model_performance.R
\name{print.model_performance}
\alias{print.model_performance}
\title{Print Dataset Level Model Performance Summary}
\usage{
\method{print}{model_performance}(x, ...)
}
\arguments{
\item{x}{a model to be explained, object of the class 'model_performance_explainer'}

\item{...}{other parameters}
}
\description{
Print Dataset Level Model Performance Summary
}
\examples{
 \donttest{
library("ranger")
titanic_ranger_model <- ranger(survived~., data = titanic_imputed, num.trees = 100,
                               probability = TRUE)
# It's a good practice to pass data without target variable
explainer_ranger  <- explain(titanic_ranger_model, data = titanic_imputed[,-8],
                             y = titanic_imputed$survived)
# resulting dataframe has predicted values and residuals
mp_ex_rn <- model_performance(explainer_ranger)
mp_ex_rn
plot(mp_ex_rn)
 }

}
