% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleCvMgof.R
\name{simpleCvMgof}
\alias{simpleCvMgof}
\title{Perform a Simple Cramer-von Mises Goodness-of-Fit Test}
\usage{
simpleCvMgof(X)
}
\arguments{
\item{X}{A numeric vector containing the sample data.}
}
\value{
\item{statistic}{The value of the Cramer-von Mises test statistic.}
\item{pvalue}{The p-value for the test.}
\item{statname}{The name of the test statistic.}
}
\description{
This function performs a simple Cramer-von Mises goodness-of-fit test to assess
whether a given sample comes from a uniform distribution. The test statistic and
p-value are calculated based on the sorted sample data.
}
\examples{
# Example usage:
set.seed(123)
X <- runif(100)  # Generate a sample from a uniform distribution
result <- simpleCvMgof(X)
print(result)

# Example with non-uniform data:
Y <- rnorm(100)  # Generate a sample from a normal distribution
result <- simpleCvMgof(Y)
print(result)
}
