% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETDQualitizer.R
\name{precision_using_moving_window}
\alias{precision_using_moving_window}
\title{Precision Using Moving Window}
\usage{
precision_using_moving_window(
  azi,
  ele,
  window_length,
  metric,
  aggregation_fun = median,
  ...
)
}
\arguments{
\item{azi}{Azimuth values.}

\item{ele}{Elevation values.}

\item{window_length}{Window size in samples.}

\item{metric}{Precision metric: \code{"RMS-S2S"}, \code{"STD"}, or \code{"BCEA"}.}

\item{aggregation_fun}{Function to aggregate precision values across the windows (default: \code{median}).}

\item{...}{Additional arguments passed to metric function.}
}
\value{
Aggregated precision value.
}
\description{
Computes gaze precision using a moving window and selected metric.
}
\examples{
precision_using_moving_window(rnorm(100), rnorm(100), 10, "STD")
}
