% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorsparsetest.R
\name{factorsparsetest}
\alias{factorsparsetest}
\title{Test of the factor model against factor augmented sparse alternative}
\usage{
factorsparsetest(x, y, w = NULL, q.levels = c(0.90, 0.95, 0.99), 
                 p.value = FALSE, rmax = 10, ...)
}
\arguments{
\item{x}{T by p data matrix, where T and p respectively denote the sample size and the number of regressors.}

\item{y}{T by 1 response variable.}

\item{w}{T BY k additional regressors added in to the factor model under H0.}

\item{q.levels}{quantile levels of effective noise.}

\item{p.value}{whether pvalue should be computed. Default is \code{FALSE}.}

\item{rmax}{maximum number of factors. Use in eigenvalue ratio estimator. Default is 10.}

\item{...}{other arguments that can be passed to \link{lassofit}.}
}
\value{
factorsparsetest object.
}
\description{
Test of the factor model against factor augmented sparse alternative
}
\details{
Computes the test statistic and the p-value for testing the factor model 
 against factor augmented sparse alternative. The number of factors are
 estimated by eigenvalue ratio estimator.
}
\examples{
set.seed(1)
x = matrix(rnorm(100 * 20), 100, 20)
beta = c(5,4,3,2,1,rep(0, times = 15))
y = x\%*\%beta + rnorm(100)
factorsparsetest(x = x, y = y)
}
\author{
Jonas Striaukas
}
