% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.metric.R
\name{screen.metric}
\alias{screen.metric}
\title{Plot a metric with trend and change points}
\usage{
screen.metric(y, ylabel = "", title = FALSE, change.margins = TRUE)
}
\arguments{
\item{y}{Numeric vector with "times" attribute, and, optionally, a 'StationID'
and a 'Agency' attribute if you want the function to auto-generate a default 
plot title.}

\item{ylabel}{Character string for the y-axis label}

\item{title}{optional plot title. Default is FALSE indicating no plot title is wanted. 
Set to TRUE to use the the default plot title, which will 
look for 'plot title' attribute of the data.frame set by 
\code{\link{set.plot.titles}}. All values other values 
will be used as a custom plot title. Set to FALSE to use this 
function in a multi-plot layout.}

\item{change.margins}{TRUE or FALSE to indicate whether the user's current 
margin settings should be used, or if the margins should be set within the 
function. Default is TRUE, to set margins to the minimal amount.}
}
\value{
Returns a list containing results from the trend and changepoint
  analysis. This list has the following elements:
  \itemize{
    \item slope - Numeric vector containing the intercept and slope of the 
      prewhitened linear trend computed with \code{\link[zyp]{zyp.trend.vector}}
      using Yue Pilon's method
    \item ci1 - numeric vector containing the intercept and slope of the
      upper confidence bound. See \code{\link[zyp]{confint.zyp}}
    \item ci2 - numeric vector of length 2 containing the intercept and slope
      of the lower confidence bound. See \code{\link[zyp]{confint.zyp}}
    \item pval - numeric value indicatng the significance value of the detected
      trend, Kendall test computed within \code{\link[zyp]{zyp.trend.vector}}
    \item cpts - numeric vector of changepoints if any are found, computed 
      with \code{\link[changepoint]{cpt.meanvar}}. Will be NULL if changepoint 
      analysis was not run due to insufficient data.
    \item means - numeric vector of means computed with 
      \code{\link[changepoint]{cpt.meanvar}}. Will be NULL if changepoint 
      analysis was not run due to insufficient data.
  }
}
\description{
This function plots a time series of a streamflow metric with the prewhitened
linear trend and any detected changepoints in mean and variance.
}
\details{
This function plots detected changepoints as a vertical dashed line.
  The means on either side of a changepoint are plotted as solid black lines.
  If the temporal trend is significant (p-value < 0.1), the trend is plotted as 
  a blue or red line for an increasing or decreasing trend, respectively.
  The upper and lower 95% confidence bounds for the trend are represented by the
  dotted red or blue lines. If a trend is not significant, it is not plotted.
}
\examples{
data(cania.sub.ts)

# calculate and plot the annual maximum series
cania.sub.ts <- set.plot.titles(cania.sub.ts)
res <- pk.max(cania.sub.ts)
res1 <- screen.metric(res, ylabel=cania.sub.ts$FlowUnit[1], 
title = TRUE)

# calculate and plot the annual minimum series
res <- MAMn(cania.sub.ts, n=1)
res1 <- screen.metric(res, ylabel="Discharge (m3/s)", 
title = TRUE)
}
\seealso{
See \code{\link{screen.summary}} to create a summary screening plot of 
  high flow, low flow, or baseflow metrics.
  
  See \code{\link{metrics.all}} to calculate 30 different streamflow metrics at once.
  The \code{\link{screen.metric}} function could then be used to loop through the metrics and 
  create an individual plot for each.
}
\author{
Jennifer Dierauer
}
