% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracfixr.r
\name{DiffPropTest}
\alias{DiffPropTest}
\title{DiffPropTest: Statistical Testing for Differential Proportions}
\usage{
DiffPropTest(NormObject, Conditions, Types, Test = c("GLM", "Logit", "Wald"))
}
\arguments{
\item{NormObject}{Output from FracFixR() function}

\item{Conditions}{Character vector of exactly 2 conditions to compare}

\item{Types}{Character vector of fraction type(s) to analyze.
Can be single fraction or multiple (will be combined)}

\item{Test}{Statistical test to use: "GLM", "Logit", or "Wald"}
}
\value{
Data frame with columns:
  \itemize{
    \item transcript: transcript identifier
    \item mean_success_cond1/2: mean proportions in each condition
    \item mean_diff: difference in proportions
    \item log2FC: log2 fold change
    \item pval: p-value from statistical test
    \item padj: FDR-adjusted p-value
  }
}
\description{
Performs statistical testing to identify transcripts with significantly
different proportions between conditions in specified fraction(s).
Implements three test options: GLM (most powerful), Logit, and Wald.
}
\details{
\itemize{
  \item GLM: Uses binomial generalized linear model (most statistically powerful)
  \item Logit: Faster alternative using logit transformation
  \item Wald: Beta-binomial Wald test for overdispersed count data
}
}
\examples{
data(example_counts)
data(example_annotation)

# Run FracFixR
results <- FracFixR(example_counts, example_annotation, parallel=FALSE)
# Run differential testing
diff_results <- DiffPropTest(results,
                            Conditions = c("Control", "Treatment"),
                            Types = "Heavy_Polysome",
                            Test = "GLM")

}
