% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_annual.R
\docType{data}
\name{example_annual}
\alias{example_annual}
\title{Example Annual Observations}
\format{
A data.frame with the following variables:
\describe{
\item{\code{WY}}{water year}
\item{\code{annual_mean}}{annual mean}
\item{\code{annual_sd}}{annual standard deviation}
\item{\code{annual_sum}}{annual sum}
\item{\code{high_q1}}{annual maximum of daily mean}
\item{\code{high_q3}}{annual maximum of 3-day mean}
\item{\code{high_q7}}{annual maximum of 7-day mean}
\item{\code{high_q30}}{annual maximum of 30-day mean}
\item{\code{high_q1_jd}}{Julian day of annual maximum of daily mean}
\item{\code{high_q3_jd}}{Julian day of annual maximum of 3-day mean}
\item{\code{high_q7_jd}}{Julian day of annual maximum of 7-day mean}
\item{\code{high_q30_jd}}{Julian day of annual maximum of 30-day mean}
\item{\code{low_q7}}{annual minimum of 7-day mean}
\item{\code{low_q30}}{annual minimum of 30-day mean}
\item{\code{low_q3}}{annual minimum of 3-day mean}
\item{\code{low_q1}}{annual minimum of daily mean}
\item{\code{low_q7_jd}}{Julian day of annual minimum of 7-day mean}
\item{\code{low_q30_jd}}{Julian day of annual minimum of 30-day mean}
\item{\code{low_q3_jd}}{Julian day of annual minimum of 3-day mean}
\item{\code{low_q1_jd}}{Julian day of annual minimum of daily mean}
\item{\code{annual_1_percentile}}{annual first percentile}
\item{\code{annual_5_percentile}}{annual 5th percentile}
\item{\code{annual_10_percentile}}{annual 10th percentile}
\item{\code{annual_25_percentile}}{annual 25th percentile}
\item{\code{annual_50_percentile}}{annual 50th percentile}
\item{\code{annual_75_percentile}}{annual 75th percentile}
\item{\code{annual_90_percentile}}{annual 90th percentile}
\item{\code{annual_95_percentile}}{annual 95th percentile}
\item{\code{annual_99_percentile}}{annual 99th percentile}
\item{\code{Jan_mean}}{annual January mean}
\item{\code{Jan_sd}}{annual January standard deviation}
\item{\code{Jan_max}}{annual January maximum}
\item{\code{Jan_min}}{annual January minimum}
\item{\code{Jan_percent_annual}}{annual January percentage of annual sum}
\item{\code{Feb_mean}}{annual February mean}
\item{\code{Feb_sd}}{annual February standard deviation}
\item{\code{Feb_max}}{annual February maximum}
\item{\code{Feb_min}}{annual February minimum}
\item{\code{Feb_percent_annual}}{annual February percentage of annual sum}
\item{\code{Mar_mean}}{annual March mean}
\item{\code{Mar_sd}}{annual March standard deviation}
\item{\code{Mar_max}}{annual March maximum}
\item{\code{Mar_min}}{annual March minimum}
\item{\code{Mar_percent_annual}}{annual March percentage of annual sum}
\item{\code{Apr_mean}}{annual April mean}
\item{\code{Apr_sd}}{annual April standard deviation}
\item{\code{Apr_max}}{annual April maximum}
\item{\code{Apr_min}}{annual April minimum}
\item{\code{Apr_percent_annual}}{annual April percentage of annual sum}
\item{\code{May_mean}}{annual May mean}
\item{\code{May_sd}}{annual May standard deviation}
\item{\code{May_max}}{annual May maximum}
\item{\code{May_min}}{annual May minimum}
\item{\code{May_percent_annual}}{annual May percentage of annual sum}
\item{\code{Jun_mean}}{annual June mean}
\item{\code{Jun_sd}}{annual June standard deviation}
\item{\code{Jun_max}}{annual June maximum}
\item{\code{Jun_min}}{annual June minimum}
\item{\code{Jun_percent_annual}}{annual June percentage of annual sum}
\item{\code{Jul_mean}}{annual July mean}
\item{\code{Jul_sd}}{annual July standard deviation}
\item{\code{Jul_max}}{annual July maximum}
\item{\code{Jul_min}}{annual July minimum}
\item{\code{Jul_percent_annual}}{annual July percentage of annual sum}
\item{\code{Aug_mean}}{annual August mean}
\item{\code{Aug_sd}}{annual August standard deviation}
\item{\code{Aug_max}}{annual August maximum}
\item{\code{Aug_min}}{annual August minimum}
\item{\code{Aug_percent_annual}}{annual August percentage of annual sum}
\item{\code{Sep_mean}}{annual September mean}
\item{\code{Sep_sd}}{annual September standard deviation}
\item{\code{Sep_max}}{annual September maximum}
\item{\code{Sep_min}}{annual September minimum}
\item{\code{Sep_percent_annual}}{annual September percentage of annual sum}
\item{\code{Oct_mean}}{annual October mean}
\item{\code{Oct_sd}}{annual October standard deviation}
\item{\code{Oct_max}}{annual October maximum}
\item{\code{Oct_min}}{annual October minimum}
\item{\code{Oct_percent_annual}}{annual October percentage of annual sum}
\item{\code{Nov_mean}}{annual November mean}
\item{\code{Nov_sd}}{annual November standard deviation}
\item{\code{Nov_max}}{annual November maximum}
\item{\code{Nov_min}}{annual November minimum}
\item{\code{Nov_percent_annual}}{annual November percentage of annual sum}
\item{\code{Dec_mean}}{annual December mean}
\item{\code{Dec_sd}}{annual December standard deviation}
\item{\code{Dec_max}}{annual December maximum}
\item{\code{Dec_min}}{annual December minimum}
\item{\code{Dec_percent_annual}}{annual December percentage of annual sum}
\item{\code{WSV}}{winter-spring volume}
\item{\code{wscvd}}{Julian date of winter-spring center volume}
}
}
\usage{
example_annual
}
\description{
An example dataset with daily observed streamflow processed to annual water year values.
}
\details{
Generated with \code{\link{example_obs}} from \preformatted{
HyMETT::preproc_main(data = example_obs, 
                     Date = "Date", value = "streamflow_cfs", longitude = -68)$annual}
}
\examples{
str(example_annual)

}
\seealso{
\code{\link{example_obs}}, \code{\link{preproc_main}}
}
\keyword{datasets}
