% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ButterflySpecies_df}
\alias{ButterflySpecies_df}
\title{Distribution of Butterfly Species in India}
\format{
A data frame with 44 observations and 9 variables:
\describe{
  \item{Serial_Number}{Serial number identifier (integer)}
  \item{Area}{Geographic area within India (factor with 8 levels)}
  \item{Locality}{Specific locality name (factor with 44 levels)}
  \item{Total_Species_count}{Total number of butterfly species in the locality (integer)}
  \item{Skippers}{Count of Skippers species (integer)}
  \item{Swallow_tails}{Count of Swallow tail species (integer)}
  \item{Whites_Yellows}{Count of Whites and Yellows species (integer)}
  \item{Blues}{Count of Blues species (integer)}
  \item{Brush_Footed}{Count of Brush Footed species (integer)}
}
}
\source{
Data taken from the \pkg{gpk} package version 1.0
}
\usage{
data(ButterflySpecies_df)
}
\description{
This dataset, ButterflySpecies_df, is a data frame containing the distribution of butterfly
species counts among five groups across different localities in India. It includes
information on the total number of species and counts for each butterfly group
such as Skippers, Swallow tails, Whites & Yellows, Blues, and Brush Footed.
}
\details{
The dataset name has been kept as 'ButterflySpecies_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
IndiAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
in any way.
}
