% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{IndiaLandReforms_df}
\alias{IndiaLandReforms_df}
\title{Politics and Land Reforms in India}
\format{
A data frame with 2670 observations and 32 variables:
\describe{
  \item{mouza}{Mouza code or identifier (integer)}
  \item{year}{Year of observation (integer)}
  \item{district}{District code or identifier (integer)}
  \item{rplacul}{Proportion of land cultivated (numeric)}
  \item{rpdrhh}{Proportion of rural households (numeric)}
  \item{rblacul}{Proportion of land below a certain threshold (numeric)}
  \item{rbgdrrghh}{Proportion of rural households with a given characteristic (numeric)}
  \item{election}{Election year indicator (integer)}
  \item{preelect}{Pre-election indicator (integer)}
  \item{edwalfco}{Electoral variable - women in local councils (numeric)}
  \item{erlesscu}{Electoral variable - less cultivated land (numeric)}
  \item{ermgcu}{Electoral variable - medium cultivated land (numeric)}
  \item{ersmcu}{Electoral variable - small cultivated land (numeric)}
  \item{ermdcu}{Electoral variable - medium developed cultivated land (numeric)}
  \item{ercusmol}{Electoral variable - custom smallholder measure (numeric)}
  \item{ercubgol}{Electoral variable - custom big landholder measure (numeric)}
  \item{erillnb}{Electoral variable - illiteracy rate (numeric)}
  \item{erlow}{Electoral variable - low-income households (numeric)}
  \item{ratleft0}{Political variable - left party ratio before adjustment (numeric)}
  \item{dwalfco}{Development variable - women in local councils (numeric)}
  \item{inflat}{Inflation rate (numeric)}
  \item{smfempyv}{Share of female employment in youth (numeric)}
  \item{incseats}{Number of seats won by incumbents (numeric)}
  \item{lfseats}{Number of seats won by left parties (numeric)}
  \item{inflflag}{Inflation flag indicator (numeric)}
  \item{inclflag}{Incumbent flag indicator (numeric)}
  \item{lflflag}{Left party flag indicator (numeric)}
  \item{ratleft}{Political variable - left party ratio (numeric)}
  \item{infiw}{Inflation index for wages (numeric)}
  \item{infumme}{Inflation index for unspecified metric (numeric)}
  \item{infal}{Inflation index for agricultural labor (numeric)}
  \item{gp}{Gram Panchayat code or identifier (integer)}
}
}
\source{
Data taken from the \pkg{pder} package version 1.0-2
}
\usage{
data(IndiaLandReforms_df)
}
\description{
This dataset, IndiaLandReforms_df, is a data frame containing information on
politics and land reforms in India. It includes variables related to agricultural
landholding patterns, rural development indicators, election outcomes, political
participation, and socio-economic measures across different districts and years.
}
\details{
The dataset name has been kept as 'IndiaLandReforms_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
IndiAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
in any way.
}
