% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc.R
\name{ccc}
\alias{ccc}
\title{Concordance Correlation Coefficient}
\usage{
ccc(x, y)
}
\arguments{
\item{x}{the vector which contains the first variable values}

\item{y}{the vector which contains the second variable values}
}
\value{
a list with 1 elements:
\item{coef}{The value of concordance correlation coeffient}
}
\description{
Classical Concordance Correlation Coefficient
}
\details{
\code{ccc} function calculates directly classical concordance correlation coefficient.
}
\examples{

x<-rnorm(50)
y<-2+3*x+rnorm(50,mean = 3)
ccc(x,y)
}
\references{
Bulut, H (2025). A Robust Concordance Correlation Coefficient. (Unpublished)

Lin, L. I. "A Concordance Correlation-Coefficient to Evaluate Reproducibility." Biometrics 45, no. 1 (1989): 255-68.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
