% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hc_search_drug.R
\name{get_hc_search_drug}
\alias{get_hc_search_drug}
\title{Search Drug Products by Brand Name in Health Canada Drug Product Database}
\source{
Health Canada Drug Product Database (DPD) API:
\url{https://health-products.canada.ca/api/documentation/dpd-documentation-en.html}
}
\usage{
get_hc_search_drug(brand_name)
}
\arguments{
\item{brand_name}{A character string representing the commercial name of the drug.}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{drug_code}: Unique code identifying the drug product
  \item \code{class_name}: Class of drug (e.g., Human, Veterinary)
  \item \code{din}: Drug Identification Number (DIN)
  \item \code{brand_name}: Brand or trade name of the product
  \item \code{number_of_ais}: Number of active ingredients
  \item \code{ai_group_no}: Active ingredient group number
  \item \code{company_name}: Manufacturer name
  \item \code{last_update_date}: Date of last update in the database
}
}
\description{
Retrieves drug products from the Health Canada Drug Product Database (DPD)
that match a specific brand (commercial) name using the RESTful API endpoint
\code{/drug/drugproduct?search=<brand_name>}.

This includes details such as the Drug Identification Number (DIN),
product name, class, number of active ingredients, company name,
and update date for each approved or discontinued pharmaceutical product.
}
\details{
This function sends a GET request to the Health Canada Drug Product Database API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

If the API request fails, returns no matches, or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from Health Canada
  get_hc_search_drug("NEMBUTAL")
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
