% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{compare_estimators_on_simulations}
\alias{compare_estimators_on_simulations}
\title{Compare MLE, ECF, and McCulloch estimators on simulated data}
\usage{
compare_estimators_on_simulations(
  n_samples = 1000,
  n_runs = 30,
  interp_alpha = NULL,
  interp_beta = NULL
)
}
\arguments{
\item{n_samples}{Integer. Number of samples per simulation.}

\item{n_runs}{Integer. Number of simulation runs.}

\item{interp_alpha}{Optional interpolation function for alpha (McCulloch).}

\item{interp_beta}{Optional interpolation function for beta (McCulloch).}
}
\value{
Data frame of simulation results with MSE and estimated parameters.
}
\description{
Runs multiple simulations and compares the mean squared error (MSE) of parameter estimates
from MLE, kernel ECF, and McCulloch methods.
}
