% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_queue_size.R
\name{wl_queue_size}
\alias{wl_queue_size}
\title{Queue size calculator}
\usage{
wl_queue_size(
  waiting_list,
  start_date = NULL,
  end_date = NULL,
  referral_index = 1,
  removal_index = 2
)
}
\arguments{
\item{waiting_list}{data.frame consisting addition and removal dates}

\item{start_date}{Date or character (in format 'YYYY-MM-DD'); start of
calculation period}

\item{end_date}{Date or character (in format 'YYYY-MM-DD'); end of
calculation period}

\item{referral_index}{the index of referrals in waiting_list}

\item{removal_index}{the index of removals in waiting_list}
}
\value{
A data.frame containing the size of the waiting list for each day in
the specified date range. If \code{start_date} and/or \code{end_date} are
\code{NULL}, the function uses the earliest and latest referral dates in
the input data.frame. The returned data.frame has the following columns:

\describe{
\item{dates}{Date. Each date within the computed range, starting from the
first referral.}
\item{queue_size}{Numeric. Number of patients on the waiting list
on that date.}
}
}
\description{
Calculates queue sizes from a waiting list
}
\examples{
referrals <- c.Date("2024-01-01", "2024-01-04", "2024-01-10", "2024-01-16")
removals <- c.Date("2024-01-08", NA, NA, NA)
waiting_list <- data.frame("referral" = referrals, "removal" = removals)
wl_queue_size(waiting_list)
}
