% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtLomax.R
\name{MvtLomax}
\alias{MvtLomax}
\alias{dmvlomax}
\alias{pmvlomax}
\alias{qmvlomax}
\alias{rmvlomax}
\alias{smvlomax}
\title{Multivariate Lomax (Pareto Type II) Distribution}
\usage{
dmvlomax(x, parm1 = 1, parm2 = rep(1, k), log = FALSE)

pmvlomax(q, parm1 = 1, parm2 = rep(1, k))

qmvlomax(p, parm1 = 1, parm2 = rep(1, k), interval = c(0, 1e+08))

rmvlomax(n, parm1 = 1, parm2 = rep(1, k))

smvlomax(q, parm1 = 1, parm2 = rep(1, k))
}
\arguments{
\item{x}{vector or matrix of quantiles. If \eqn{x} is a matrix, each row vector constitutes a vector of quantiles for which the density \eqn{f(x)} is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{parm1}{a scalar parameter, see parameter \eqn{a} in \strong{Details}.}

\item{parm2}{a vector of parameters, see parameters \eqn{\theta_i} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities \eqn{f} are given as \eqn{log(f)}.}

\item{q}{a vector of quantiles.}

\item{p}{a scalar value corresponding to probability.}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(0, 1e8)}.}

\item{n}{number of observations.}

\item{k}{dimension of data or number of variates.}
}
\value{
\code{dmvlomax} gives the numerical values of the probability density.

\code{pmvlomax} gives the cumulative probability.

\code{qmvlomax} gives the equicoordinate quantile.

\code{rmvlomax} generates random numbers.

\code{smvlomax} gives the value of survival function.
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for multivariate Lomax (Pareto Type II) distribution with a scalar parameter \code{parm1} and vector parameter \code{parm2}.
}
\details{
Multivariate Lomax (Pareto type II) distribution was introduced by Nayak (1987) as a joint probability distribution of several skewed positive random variables \eqn{X_1, X_2, \cdots, X_k}. Its probability density function is given by
\deqn{f(x_1, x_2, \dots, x_k) = \frac{[ \prod_{i=1}^{k} \theta_i] a(a+1) \cdots (a+k-1)}{(1+\sum_{i=1}^{k} \theta_i x_i)^{a+k}},}
where \eqn{x_i > 0, a>0, \theta_i>0, i=1,\dots,k}.

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is obtained by the following formula related to survival function \eqn{\bar{F}(x_1, \dots, x_k)} (Joe, 1997)
\deqn{F(x_1, \dots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} \bar{F}_S(x_j, j \in S),}
where the survival function is given by
\deqn{\bar{F}(x_1, \dots, x_k) = ( 1+\sum_{i=1}^{k} \theta_i x_i )^{-a}.}

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{0}^{q} \cdots \int_{0}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

Random numbers from multivariate Lomax distribution can be generated by simulating \eqn{k} independent exponential random variables having a common environment parameter following gamma distribution with shape parameter \eqn{a} and scale parameter \eqn{1}; see Nayak (1987).
}
\examples{
# Calculations for the multivariate Lomax with parameters: 
# a = 5, theta1 = 1, theta2 = 2 and theta3 = 3.
# Vector of quantiles: c(3, 2, 1)

dmvlomax(x = c(3, 2, 1), parm1 = 5, parm2 = c(1, 2, 3)) # Density

pmvlomax(q = c(3, 2, 1), parm1 = 5, parm2 = c(1, 2, 3)) # Cumulative Probability

# Equicoordinate quantile of cumulative probability 0.5
qmvlomax(p = 0.5, parm1 = 5, parm2 = c(1, 2, 3)) 

# Random numbers generation with sample size 100
rmvlomax(n = 100, parm1 = 5, parm2 = c(1, 2, 3)) 

smvlomax(q = c(3, 2, 1), parm1 = 5, parm2 = c(1, 2, 3)) # Survival function

}
\references{
Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
