% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogi.R
\name{cov2biu}
\alias{cov2biu}
\title{Bi-unit Canonical Form}
\usage{
cov2biu(S, nu = rep(1, nrow(S)), force = FALSE, detail = FALSE)
}
\arguments{
\item{S}{Covariance matrix, especially it is positive semi-definite.}

\item{nu}{Numeric vector of subjective importance. It determines the
importance of each of the variates.}

\item{force}{Logical: if force=FALSE, \code{S} should be strictly positive
definite. Default: FALSE.}

\item{detail}{Logical: if detail=TRUE, it returns the list of the bi-unit
form and the weight vectors. Default: FALSE.}
}
\value{
Numeric matrix of the bi-unit canonical form \eqn{DSD} of \eqn{S}.
}
\description{
\code{cov2biu(S)} returns the bi-unit canonical form of \code{S}.
}
\examples{
S = matrix(0, 5, 5)
S[1,1] = 1
for(j in 2:5) S[1,j] = S[j,1] = -0.5
for(i in 2:5){
  for(j in 2:5){
    if(i == j) S[i,j] = 1
    else S[i,j] = 0.5
  }
}
B=cov2biu(S)
B
}
