% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogi.R
\name{ogi}
\alias{ogi}
\title{Objective General Index}
\usage{
ogi(X, se = FALSE, force = FALSE, se.loop = 1000, nu = rep(1, ncol(X)),
  center = TRUE, mar = FALSE)
}
\arguments{
\item{X}{Numeric or ordered matrix.}

\item{se}{Logical: if se=TRUE, it additionally computes \code{w.se} and
\code{v.se} by bootstrap. Default: FALSE.}

\item{force}{Logical: if force=FALSE, \code{S} should be strictly positive
definite. Default: FALSE.}

\item{se.loop}{Iteration number in bootstrap for computation of standard
error.}

\item{nu}{Numeric vector of subjective importance. It determines the
importance of each column of \code{X}.}

\item{center}{Logical: if center=TRUE, \code{ogi(X)$Z} is centered.
Default:TRUE.}

\item{mar}{Logical: if mar=TRUE, each of ordered categorical variates of
\code{X} (if exists) is marginally converted into a numeric vector in
advance by the univariate OGI quantification. If mar=FALSE, the
simultaneous OGI quantification is applied. Default:FALSE.}
}
\value{
\item{value}{The objective general index (OGI).}
\item{X}{The input matrix \code{X}.}
\item{scaled}{The product of \code{Z \%*\% diag(weight)}, where \code{Z} and
  \code{weight} are as follows.}
\item{Z}{Numerical matrix converted from \code{X}. If center = TRUE, it is centered.}
\item{weight}{The output of \code{\link{cov2weight}(S, nu=nu, force=force)},
  where \code{S} is the covariance matrix of \code{X}. }
\item{rel.weight}{The product of \code{weight * sqrt(diag(S))}, where \code{S}
  is the covariance matrix of \code{X}.}
\item{biu}{The bi-unit canonical form of the covariance matrix of \code{X}.}
\item{idx}{Numeric vector. If \code{X} has ordered categorical variates,
  \code{idx} has (number of levels) -1 number of indexes.}
\item{w.se}{If requested, \code{w.se} is numeric vector of the standard error
  of \code{weight}. It is calculated by bootstrap.}
\item{v.se}{If requested, \code{v.se} is numeric vector of the standard error
  of \code{value}. It is calculated by bootstrap.}
}
\description{
\code{ogi(X)} returns the objective general index (OGI) of the covariance
matrix \code{S} of \code{X}.
}
\details{
Consider a data matrix of \eqn{n} individuals with \eqn{p} variates. The
objective general index (OGI) is a general index that combines the \eqn{p}
variates into a univariate index in order to rank the \eqn{n} individuals.
The OGI is always positively correlated with each of the variates. For more
details, see the references.
}
\examples{
CT = matrix(c(
2,1,1,0,0,
8,3,3,0,0,
0,2,1,1,1,
0,0,0,1,1,
0,0,0,0,1), 5, 5, byrow=TRUE)
X = matrix(0, 0, 2)
for(i in 1:5){
  for(j in 1:5){
    if(CT[i,j]>0){
      X = rbind(X, matrix(c(6-i,6-j), CT[i,j], 2, byrow=TRUE))
    }
  }
}
X0 = X
X = as.data.frame(X0)
X[,1] = factor(X0[,1], ordered=TRUE)
X[,2] = factor(X0[,2], ordered=TRUE)
ogiX = ogi(X)
par(pty="s", cex=1.7, mar=c(4.5,3,1,1))
plot(ogiX$scaled, xlim=c(-3,3), ylim=c(-3,3), xlab="Geometry", ylab="Probability")
for(t in 1:nrow(ogiX$scaled)){
  xy = ogiX$scaled[t,]
  g = rep(sum(xy)/2, 2)
  segments(xy[1], xy[2], g[1], g[2], lty=2)
}
arrows(-3, -3, 3, 3)
text(2.5, 2, "OGI/2")
ogiX


f = ordered(1:10)
f[sample(1:10, 20, replace=TRUE)]
Y = ogi(f)$value
plot((1:10)/(10+1), Y, type="b")
xs = (1:1000)/1001
points(xs, qnorm(xs), type="l", col="red")


X = USJudgeRatings
ogiX = ogi(X)
nameX = ordered(names(X), names(X))
plot(nameX, ogiX$weight, las=3, cex.axis=0.8, ylim=c(0,1.2), ylab="weight")
}
\references{
Sei, T. (2016). An objective general index for multivariate
  ordered data, Journal of Multivariate Analysis, 147, 247-264.
  \url{http://www.sciencedirect.com/science/article/pii/S0047259X16000269}
}
