% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MultiExponential.R
\name{plot_MultiExponential}
\alias{plot_MultiExponential}
\title{Advanced plot function for displaying component resolved signal curves}
\usage{
plot_MultiExponential(
  curve = NULL,
  components = NULL,
  fill.components = TRUE,
  linear.modulation = FALSE,
  xlog = FALSE,
  ylog = FALSE,
  main = NULL,
  xlab = "Time",
  ylab = "Signal",
  xlim = NULL,
  ylim = NULL,
  font.size = 10,
  graph.colors = NULL,
  graph.names = NULL,
  legend.position = "right",
  legend.justification = NULL,
  theme.set = ggplot2::theme_classic(),
  hide.plot = FALSE
)
}
\arguments{
\item{curve}{\link{data.frame} or \link{matrix} or \link[Luminescence:RLum.Data.Curve-class]{Luminescence::RLum.Data.Curve} (\emph{optional}):
Measured signal curve. First column is used as x-axis, second column is used as y-axis.
Further columns are ignored. If this argument is \code{NULL} but a component table is given,
signal components and a modeled multi-exponential signal curve will be displayed nonetheless.}

\item{components}{\link{data.frame} or \link{numeric} vector (\strong{optional})
Either table with the signal component parameters or numeric vector with decay rates.
The component parameter table is usually given by \link{fit_OSLcurve} or \link{decompose_OSLcurve}.
If handmade, it needs the columns \verb{$names}, \verb{$lambda} and \verb{$n}.T
This argument also accepts numeric vectors, the component intensity will be calculated automatically
using \link{decompose_OSLcurve}. If the vector elements are named, these names will be used as component names.}

\item{fill.components}{\link{logical} (\emph{with default}):
If \code{TRUE}, signal components are displayed ad stacked areas. Otherwise they are displayed as line graphs.}

\item{linear.modulation}{\link{logical} (\emph{with default}):
If \code{TRUE}, all graphs are transformed to linear modulated curves, a peak-like representation for decay curves.
See Bulur (2000) and Bos and Wallinga (2012) for details.}

\item{xlog}{\link{logical} (\emph{with default}):
If \code{TRUE}, x-axis is transformed to logarithmic scale.}

\item{ylog}{\link{logical} (\emph{with default}):
If \code{TRUE}, y-axis is transformed to logarithmic scale.}

\item{main}{\link{character} (\emph{optional}):
Plot title, drawn at the top left of the diagram.}

\item{xlab}{\link{character} (\emph{optional}):
Axis title of the x-axis.}

\item{ylab}{\link{character} (\emph{optional}):
Axis title of the y-axis.}

\item{xlim}{\link{numeric} vector (\emph{optional}):
Minimum and maximum \code{c(min, max)} of the x-scale.}

\item{ylim}{\link{numeric} vector (\emph{optional}):
Minimum and maximum \code{c(min, max)} of the y-scale.}

\item{font.size}{\link{numeric} (\emph{with default}):
Scale factor for all text elements. Legend title and main title are one bigger}

\item{graph.colors}{\link{character} vector (\emph{optional}):
Color for the graphs/stacked areas are defined in the following order: 1. Measurement,
2. Model, 3. Component 1, 4. Component 2, etc. The color vector is allowed to
be shorter than the needed colors. For missing colors, the default colors will be used}

\item{graph.names}{\link{character} vector (\emph{optional}):
Alternative graph names which shall be displayed in the legend. The names are defined
in the following order: 1. Measurement, 2. Model, 3. Residual, 4. Component 1, 5. Component 2, etc..
For missing names, the default names will be used.}

\item{legend.position}{\link{character} two-point \link{numeric} vector (\emph{with default}):
Position of the plot legend  (for example \code{"bottom"} or \code{c(1,1)}).
Set to "none" for not drawing a legend. This argument is forwarded to \link[ggplot2:theme]{ggplot2::theme}.}

\item{legend.justification}{\link{character} two-point \link{numeric} vector (\emph{with default}):
Anchor point for positioning the legend (for example \code{"right"} or \code{c(1,1)}).
This argument is forwarded to \link[ggplot2:theme]{ggplot2::theme}.}

\item{theme.set}{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2-package} object (\emph{with default}):
Graphical theme of the output plot. This argument is forwarded to \link[ggplot2:theme_get]{ggplot2::theme_set}.
Recommended themes are \code{ggplot2::theme_minimal()}, \code{ggplot2::theme_classic()} and \code{ggplot2::theme_bw()},
see \link[ggplot2:ggtheme]{ggplot2::theme_bw} or \href{https://ggplot2.tidyverse.org/reference/ggtheme.html}{here} for
a full list.}

\item{hide.plot}{\link{logical} (\emph{with default}):
If true, plot is not drawn but can still be saved as file or caught by \code{A <- plot_OSLcurve(...)}.
If caught, the plot can be drawn manually for example by using \link[gridExtra:arrangeGrob]{gridExtra::grid.arrange}.}
}
\value{
Returns an invisible \link[ggplot2:ggplot]{ggplot2::ggplot} object containing the plot "Invisible" means, the no value
will be returned (e.g. no console printout) if the function is not assigned to a variable via \verb{<-}.
If the function is assigned, the returned object can be further manipulated by \link[ggplot2:ggplot2-package]{ggplot2::ggplot2-package} methods
or manually drawn by various functions like for example \link[gridExtra:arrangeGrob]{gridExtra::grid.arrange}.
}
\description{
This function plots multi-exponentially decaying measurements and its signal components.
\link{plot_OSLcurve} is a wrapper for this function.

This function was black-box tested prior release.
These tests as well as code examples are available at:
https://luminescence.de/OSLdecomposition/module_tests/Test_plot_MultiExponential.html
}
\section{Last update}{


2024-08-29, DM: Forked this function from plot_OSLcurve
}

\examples{

library(ggplot2)

# Set some arbitrary decay parameters
decay_rates <- c(Fast = 1.2, Medium = 0.2, Slow = 0.02)

# Simulate a CW-OSL curve including some signal noise and signal background
curve <- simulate_OSLcomponents(data.frame(lambda = decay_rates,
                                           n = c(1000, 2000, 10000)),
                                simulate.curve = TRUE,
                                add.poisson.noise = TRUE,
                                add.background = 10)

# Plot the simulated curve and its signal components
plot_MultiExponential(curve, decay_rates)

# For more examples, follow the link to the module tests given in the description section.

}
\references{
Bos, A. J. J. and Wallinga, J., 2012. How to visualize quartz OSL signal components,
Radiation Measurements, 47(9)

Bulur, E., 2000. A simple transformation for converting CW-OSL curves to LM-OSL curves,
Radiation Measurements, 32(2)
}
\seealso{
\link{plot_OSLcurve}, \link{fit_OSLcurve}, \link{simulate_OSLcomponents}
}
\author{
Dirk Mittelstraß, \email{dirk.mittelstrass@luminescence.de}

Please add the following references to your publication: Your currently used package version, obtained by
\code{citation("OSLdecomposition")}

Mittelstraß, D., Schmidt, C., Kreutzer, S., Beyer, J., Straessner, A. and Heitmann, J.:
R package OSLdecomposition: Automated signal component analysis of multi-exponential decays for optically stimulated luminescence applications., \emph{in preparation}.
}
