% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-openrepgrid.r
\docType{data}
\name{df_long}
\alias{df_long}
\title{Sample dataframe with grid data (long)}
\description{
This dataframe can be converted into a \code{repgrid} object via \code{\link[=importDataframe]{importDataframe()}}.
The \code{long} format has this name because it has few columns and many rows. It is a common format
in data analytics. Here, each row contains a different element-construct combination and the corresponding rating
value. The format looks like this:
}
\details{
\tabular{lllrlrr}{
\code{element}   \tab \code{left_pole}   \tab \code{right_pole}   \tab \code{rating} \tab \code{preferred_pole} \tab \code{rmin} \tab \code{rmax} \cr
\verb{element 1} \tab \verb{left pole 1} \tab \verb{right pole 1} \tab \code{5}      \tab \code{left}           \tab \code{1}    \tab \code{5}   \cr
\code{element_2} \tab \verb{left pole 1} \tab \verb{right pole 1} \tab \code{3}      \tab \code{left}           \tab \code{1}    \tab \code{5}   \cr
\code{element_3} \tab \verb{left pole 1} \tab \verb{right pole 1} \tab \code{1}      \tab \code{left}           \tab \code{1}    \tab \code{5}   \cr
}

The columns \code{element}, \code{left_pole}, \code{right_pole}, and \code{rating} are mandatory, the columns \code{preferred_pole}, \code{rmin},
and \code{rmax} are optional. \code{rmin} and \code{rmax} contain the min and max of the rating scale. Alternatively, you may
pass \code{rmin} and \code{rmax} as arguments in the function call.
}
\examples{
df_long
importDataframe(df_long, format = "long")
}
\seealso{
\code{\link[=importDataframe]{importDataframe()}}

Other grid dataframes: 
\code{\link{df_construct_columns}},
\code{\link{df_element_columns}}
}
\concept{grid_dataframe}
\keyword{data}
