% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{importTxt}
\alias{importTxt}
\title{Import grid data from a text file.}
\usage{
importTxt(file, dir = NULL, min = NULL, max = NULL)
}
\arguments{
\item{file}{A vector of filenames including the full path if file is not in current working
directory. File can also be a complete URL. The file suffix
has to be \code{.txt}.}

\item{dir}{Alternative way to supply the directory where the file is located
(default \code{NULL}).}

\item{min}{Optional argument (\code{numeric}, default \code{NULL})
for minimum rating value in grid.}

\item{max}{Optional argument (\code{numeric}, default \code{NULL})
for maximum rating value in grid.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   A single `repgrid` object in case one file and
           a list of `repgrid` objects in case multiple files are imported.
}\if{html}{\out{</div>}}
}
\description{
You can define a grid using a standard text editor and saving it as a \code{.txt} file.
The \emph{Details} section describes the required format of the \code{.txt} file. However, you may also
consider using the Excel format instead, as it has a more intuitive format (see \code{\link[=importExcel]{importExcel()}}).
}
\details{
The \code{.txt} file has to be in a fixed format. There are \emph{three mandatory blocks} each starting and ending
with a predefined tag in uppercase letters. The first block starts with \code{ELEMENTS} and ends with \verb{END ELEMENTS}.
It contains one element per line. The other mandatory blocks are \code{CONSTRUCTS} and \code{RATINGS} (see below). In the
block containing the constructs the left and right pole are separated by a colon (\code{:}). To define missing values
use \code{NA}. The block \code{PREFERRED} is \emph{optional}. Each line indicated the preferred construct pole. Allowed values
are \code{left}, \code{right}, \code{none} (no pole preferred), and \code{NA} (unknown). The block \code{RANGE} is \emph{optional} but
recommended. It gives the rating scale range defined by two numbers. The order of the blocks is arbitrary. All
text oustide the blocks is discarded and can be used for comments.

The content of a sample \code{.txt} file is shown below. The package also contains a sample file (see \emph{Examples}).

\if{html}{\out{<div class="sourceCode">}}\preformatted{---------------- sample .txt file -------------------

    Note: anything outside the tag pairs is discarded

ELEMENTS
element 1
element 2
element 3
END ELEMENTS

CONSTRUCTS
left pole 1 : right pole 1
left pole 2 : right pole 2
left pole 3 : right pole 3
left pole 4 : right pole 4
END CONSTRUCTS

PREFERRED
left
left
right
none
END PREFERRED

RATINGS
1 3 2
4 1 1
1 4 4
3 1 1
END RATINGS

RANGE
1 4
END RANGE

------------------ end of file ------------------
}\if{html}{\out{</div>}}

Note that the maximum and minimum value has to be defined using the \code{min} and \code{max} arguments if no \code{RANGE} block is
contained in the data file. Otherwise the scaling range is inferred from the available data and a warning is issued
as the range may be erroneous. This may effect other functions that depend on knowing the correct range and it is
thus strongly recommended to set the scale range correctly.
}
\examples{
# Import a .txt file delivered along with the package
file <- system.file("extdata", "grid_01.txt", package = "OpenRepGrid")
rg <- importTxt(file)

# To see the structure of the file, try opening it as follows.
# (may not work on all systems)
\dontrun{
file.show(file)
}

# Import more than one .txt file
files <- system.file("extdata", c("grid_01.txt", "grid_02.txt"), package = "OpenRepGrid")
rgs <- importTxt(files)

}
\seealso{
Import data
\code{\link{importDataframe}()},
\code{\link{importExcel}()},
\code{\link{importGridcor}()},
\code{\link{importGridstat}()},
\code{\link{importGridsuite}()},
\code{\link{importScivesco}()}
}
\concept{import}
