% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm.R
\name{openproj}
\alias{openproj}
\title{Projects the open street map to an alternate coordinate system}
\usage{
openproj(x, projection = "+proj=longlat", ...)
}
\arguments{
\item{x}{an OpenStreetMap object}

\item{projection}{a proj4 character string or CRS object}

\item{...}{additional parameters for projectRaster}
}
\description{
Projects the open street map to an alternate coordinate system
}
\examples{
\dontrun{
library(maps)

#plot map in native mercator coords
map <- openmap(c(70,-179),
	c(-70,179),zoom=1,type="esri-imagery")
plot(map)

#using longlat projection lets us combine with the maps library
map_longlat <- openproj(map)
plot(map_longlat)
map("world",col="red",add=TRUE)

#robinson projection. good for whole globe viewing.
map_robinson <- openproj(map_longlat, projection=
"+proj=robin +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
plot(map_robinson)

#national parks service images
upperMap <- openmap(c(70,-179),
	c(10,50),zoom=2,type='nps')
#Lambert Conic Conformal
map_llc <- openproj(upperMap, projection=
"+proj=lcc +lat_1=33 +lat_2=45 +lat_0=39 +lon_0=-96")
plot(map_llc,removeMargin=TRUE)
#add choropleth
library(sp)
data(states)
st_llc <- spTransform(states,CRS("+proj=lcc +lat_1=33 +lat_2=45 +lat_0=39 +lon_0=-96"))
plot(st_llc,add=T,col=heat.colors(48,.4)[slot(st_llc,"data")[["ORDER_ADM"]]])

}
}
