% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.outliers.R
\name{outlier.detection.cosine}
\alias{outlier.detection.cosine}
\title{Cosine similarity}
\usage{
outlier.detection.cosine(x, distribution)
}
\arguments{
\item{x}{A numeric vector.}

\item{distribution}{A numeric code corresponding to the optimal distribution of \code{x} as returned by \code{identify.bic.optimal.data.distribution()}.}
}
\value{
A number.
}
\description{
Compute cosine similarity for detection of outliers.  Generate theoretical quantiles based on the optimal distribution of the data, and compute cosine similarity between a point made up of the largest observed quantile and the largest theoretical quantile and a point on the line y = x.
.
}
\examples{
# Generate fake data.
set.seed(1234);
x <- rgamma(
    n = 20,
    shape = 2,
    scale = 2
    );
outlier.detection.cosine(
    x = x,
    distribution = 4
    );
}
