#' Leukemia data set
#' 
#' @format This dataset comes from a study of gene expression in two types of acute leukemias, acute lymphoblastic leukemia (ALL) and acute myeloid leukemia (AML). Gene expression levels were measured using Affymetrix high density oligonucleotide arrays containing 6817 human genes. A data set containing 72 observations from 3 leukemia types classes. 
#' \describe{
#'   \item{Type}{has 3 classes with 38 cases of B-cell ALL, 25 cases of AML and 9 cases of T-cell ALL.} 
#'   \item{Gene1, Gen2, ..., Gen40}{ gene expression levels.}
#'}
#' @docType data
#' @keywords datasets
#' @name leukemia
#' @usage data(leukemia)
#' @format A data frame with 72 rows and 41 variables
#' @source Dudoit, S., Fridlyand, J. and Speed, T. P. (2002). Comparison of Discrimination Methods for the Classification of Tumors Using Gene Expression Data. Journal of the American statistical Association 97 77-87.
NULL
