% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect_functions.R
\name{acc_mi}
\alias{acc_mi}
\title{PVB correction by multiple imputation}
\usage{
acc_mi(
  data,
  test,
  disease,
  covariate = NULL,
  ci = FALSE,
  ci_level = 0.95,
  m = 100,
  seednum = NA,
  method = "logreg",
  mi_print = FALSE,
  description = TRUE
)
}
\arguments{
\item{data}{A data frame, with at least "Test" and "Disease" variables.}

\item{test}{The "Test" variable name, i.e. the test result. The variable must be in binary; positive = 1, negative = 0 format.}

\item{disease}{The "Disease" variable name, i.e. the true disease status. The variable must be in binary; positive = 1, negative = 0 format.}

\item{covariate}{The name(s) of covariate(s), i.e. other variables associated with either test or disease status.
Specify as name vector, e.g. c("X1", "X2") for two or more variables. The variables must be in formats acceptable to GLM.}

\item{ci}{View confidence interval (CI). The default is \code{FALSE}.}

\item{ci_level}{Set the CI width. The default is 0.95 i.e. 95\% CI.}

\item{m}{The number of imputation, m.}

\item{seednum}{Set the seed number for the bootstrapped CI. The default is not set, so it depends on the user
to set it outside or inside the function.}

\item{method}{Imputation method. The default is "logreg". Other allowed methods are
"logreg.boot", "pmm", "midastouch", "sample", "cart", "rf".
See \code{\link[mice]{mice}} for details of these methods.}

\item{mi_print}{Print multiple imputation history on console.
This is \code{\link[mice]{mice}} \code{print} option. The default is \code{FALSE}.}

\item{description}{Print the name of this analysis. The default is \code{TRUE}. This can be turned off for repeated analysis, for example in bootstrapped results.}
}
\value{
A list object containing:
\describe{
  \item{acc_results}{The accuracy results.}
}
}
\description{
Perform PVB correction by multiple imputation.
}
\examples{
# with logreg
acc_mi(data = cad_pvb, test = "T", disease = "D", ci = TRUE, seednum = 12345, m = 5)

# with other imputation method. e.g. predictive mean matching "pmm"
acc_mi(data = cad_pvb, test = "T", disease = "D", ci = TRUE, seednum = 12345, m = 5,
       method = "pmm")

# with covariate and confidence interval
acc_mi(data = cad_pvb, test = "T", disease = "D", covariate = "X3",
       ci = TRUE, seednum = 12345, m = 5)

}
\references{
\enumerate{
  \item{Harel, O., & Zhou, X.-H. (2006). Multiple imputation for correcting verification bias. Statistics in Medicine, 25(22), 3769–3786.}
}
}
