% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_api.R
\name{call_openai_chat}
\alias{call_openai_chat}
\title{Call OpenAI API}
\usage{
call_openai_chat(messages, model)
}
\arguments{
\item{messages}{List of messages (each a list with 'role' and 'content').}

\item{model}{OpenAI model to use.}
}
\value{
Character string with assistant reply, or NULL on unexpected response.
}
\description{
Sends messages to the OpenAI Chat Completions API and returns the assistant content.
Temperature is not sent; models run with API defaults.
}
\examples{
\dontrun{
  msgs <- list(
    list(role = "system", content = "You are concise."),
    list(role = "user", content = "What does httr do?")
  )
  call_openai_chat(messages = msgs, model = "gpt-5-mini")
}
}
