% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{iscd_education_tbl_df}
\alias{iscd_education_tbl_df}
\title{Peru's educational programs under ISCED classification}
\format{
A tibble with 8,357 observations and 8 variables:
\describe{
  \item{Education_COD}{Education classification code (character)}
  \item{Education}{Education category description (character)}
  \item{Specific_COD}{Specific classification code (character)}
  \item{Specific}{Specific category description (character)}
  \item{AcademicLevel}{Academic level description (character)}
  \item{AcademicLevel_COD}{Academic level code (character)}
  \item{EducationProgram}{Education program name (character)}
  \item{EducationProgram_Lemma}{Education program lemmatized form (character)}
}
}
\source{
Data taken from the \pkg{CINE} package version 0.1.3
}
\usage{
data(iscd_education_tbl_df)
}
\description{
This dataset, iscd_education_tbl_df, is a tibble containing Peru's educational programs
classified according to the International Standard Classification of Education (ISCED).
It provides comprehensive information about educational codes, classifications, academic levels,
and program specifications used in Peru's educational system, facilitating standardized
comparison and analysis of educational data.
}
\details{
The dataset name has been kept as 'iscd_education_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PeruAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
