% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/para_limits.r
\name{para_limits}
\alias{para_limits}
\title{Parametric Limits, based on Normal}
\usage{
para_limits(mean, sd, N, censor=0, winsor=0, perc=0.95, cover=0.9)
}
\arguments{
\item{mean}{the mean of a complete normal sample, or
the intercept of the QQ regression of a censored or winsorized sample.}

\item{sd}{the sd of a complete normal sample, or
the slope of the QQ regresion of a censorised or winsorized sample.}

\item{N}{the sample size}

\item{censor}{\emph{optional} (default of 0) - the number of left-censored readings}

\item{winsor}{\emph{optional} (default of 0) - the number winsorized in each tail}

\item{perc}{\emph{optional} (default of 0.95) - the two-sided coverage sought}

\item{cover}{\emph{optional} (default of 0.9) - the confidence level of the CI
on the reference limit}
}
\value{
A list containing the following components:

\item{lower}{the lower reference limit and its CI}
\item{upper}{the upper reference limit and its CI}
\item{effn}{the effective sample size with censoring or winsorization}
}
\description{
Parametric confidence limit for a normal or normal-in-the-middle sample.
}
\details{
This function computes two-sided reference limits and their
confidence intervals for data that are normal;
normal across the reference interval; or censored normal.
The reference limits are conventional mean + z*se, and their
confidence intervals come from the delta method.
}
\examples{
# parameters
mu    <- 40
sigma <- 10
n     <- 120
# identifying winsoring
wins  <- trunc(n/40)
# replicable randomization
set.seed(1069)
X     <- mu + sigma*rnorm(n)
# replicable randomization with heavy tails
set.seed(1069)
HT    <- mu + sigma * rt(n, 5)

# retain original visual settings
oldsettings <- par(mfrow=par()$mfrow, oma=par()$oma)
# visual settings
par(mfrow=c(2,2))
par(oma=c(0,0,2,0))
# plot to compare
base <- QQnorm(X, main="Base normal", showsum=TRUE)
title("Illustrating QQnorm with para_limits", outer=TRUE)
basew <- QQnorm(X, main="Winsorized", winsor=wins, showsum=TRUE)
ht   <- QQnorm(HT, main="Heavy tail", showsum=TRUE)
htw  <- QQnorm(HT, main="Winsorized", winsor=wins, showsum=TRUE)
# restore
par(oldsettings)

# evaluate and review
norm_results <- para_limits(mean(X), sd(X), n)
norm_results
# evaluate and review with tails
tailed_results <- para_limits(htw$intercept, htw$slope, n, winsor=wins)
tailed_results

}
\references{
Horn PS, Peske AJ (2005). Reference intervals: a user’s guide. Washington (DC): AACC Press.
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
