% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Print.R
\name{print}
\alias{print}
\alias{print.CDM}
\alias{print.validation}
\alias{print.sim.data}
\alias{print.fit}
\alias{print.is.Qident}
\alias{print.att.hierarchy}
\alias{print.summary.CDM}
\alias{print.summary.validation}
\alias{print.summary.sim.data}
\alias{print.summary.fit}
\alias{print.summary.is.Qident}
\alias{print.summary.att.hierarchy}
\title{Print Methods for Various Objects}
\usage{
\method{print}{CDM}(x, ...)

\method{print}{validation}(x, ...)

\method{print}{sim.data}(x, ...)

\method{print}{fit}(x, ...)

\method{print}{is.Qident}(x, ...)

\method{print}{att.hierarchy}(x, ...)

\method{print}{summary.CDM}(x, ...)

\method{print}{summary.validation}(x, ...)

\method{print}{summary.sim.data}(x, ...)

\method{print}{summary.fit}(x, ...)

\method{print}{summary.is.Qident}(x, ...)

\method{print}{summary.att.hierarchy}(x, ...)
}
\arguments{
\item{x}{An object of the appropriate class (e.g., \code{\link[Qval]{CDM}}, 
\code{\link[Qval]{validation}}, \code{\link[Qval]{sim.data}}, 
\code{\link[Qval]{fit}}, \code{\link[Qval]{is.Qident}}, 
\code{\link[Qval]{att.hierarchy}}, or their summaries).}

\item{...}{Currently unused.  Additional arguments are ignored.}
}
\value{
Invisibly returns \code{x}.
}
\description{
Print concise, user-friendly summaries of objects generated by the Qval package.
Supports objects of classes \code{\link[Qval]{CDM}}, \code{\link[Qval]{validation}}, \code{\link[Qval]{sim.data}}, 
\code{\link[Qval]{fit}}, \code{\link[Qval]{is.Qident}}, \code{\link[Qval]{att.hierarchy}}, 
as well as their corresponding summary objects.
}
\details{
The \code{print} methods provide an at-a-glance view of key information:
\describe{
  \item{\code{print.CDM}}{displays sample size, item and attribute counts, and package information.}
  \item{\code{print.validation}}{shows suggested modifications to the Q-matrix, marking changed entries with an asterisk.}
  \item{\code{print.sim.data}}{reports dimensions of simulated data and offers guidance on extraction.}
  \item{\code{print.fit}}{show basic fit indices.}
  \item{\code{print.is.Qident}}{prints basic results from \code{is.Qident}.}
  \item{\code{print.att.hierarchy}}{prints basic results from \code{att.hierarchy}.}
  \item{\code{print.summary.CDM}}{prints fitted model details and alpha-pattern distribution from a \code{summary.CDM} object.}
  \item{\code{print.summary.validation}}{prints suggested Q-matrix changes or a message if none are recommended.}
  \item{\code{print.summary.sim.data}}{prints attribute-pattern frequencies and proportions from \code{summary.sim.data}.}
  \item{\code{print.summary.fit}}{prints basic fit indices from \code{summary.fit}.}
  \item{\code{print.summary.is.Qident}}{prints basic results from \code{summary.is.Qident}.}
  \item{\code{print.summary.att.hierarchy}}{prints basic results from \code{summary.att.hierarchy}.}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{print(CDM)}: Print method for \code{CDM} objects

\item \code{print(validation)}: Print method for \code{validation} objects

\item \code{print(sim.data)}: Print method for \code{sim.data} objects

\item \code{print(fit)}: Print method for \code{fit} objects

\item \code{print(is.Qident)}: Print method for \code{is.Qident} objects

\item \code{print(att.hierarchy)}: Print method for \code{att.hierarchy} objects

\item \code{print(summary.CDM)}: Print method for \code{summary.CDM} objects

\item \code{print(summary.validation)}: Print method for \code{summary.validation} objects

\item \code{print(summary.sim.data)}: Print method for \code{summary.sim.data} objects

\item \code{print(summary.fit)}: Print method for \code{summary.fit} objects

\item \code{print(summary.is.Qident)}: Print method for \code{summary.is.Qident} objects

\item \code{print(summary.att.hierarchy)}: Print method for \code{summary.att.hierarchy} objects

}}
\examples{
set.seed(123)
library(Qval)

\donttest{
################################################################
# Example 1: print a CDM object                                #
################################################################
Q <- sim.Q(3, 20)
IQ <- list(P0 = runif(20, 0.0, 0.2), P1 = runif(20, 0.8, 1.0))
data.obj <- sim.data(Q = Q, N = 500, IQ = IQ, 
                     model = "GDINA", distribute = "horder")
CDM.obj <- CDM(data.obj$dat, Q, model = "GDINA", 
               method = "EM", maxitr = 2000, verbose = 1)
print(CDM.obj)


################################################################
# Example 2: print a validation object                         #
################################################################
set.seed(123)
MQ <- sim.MQ(Q, 0.1)
CDM.obj <- CDM(data.obj$dat, MQ)
validation.obj <- validation(data.obj$dat, MQ, CDM.obj, 
                             method = "GDI")
print(validation.obj)


################################################################
# Example 3: print a sim.data object                           #
################################################################
set.seed(123)
Q2 <- sim.Q(3, 10)
data.obj2 <- sim.data(Q = Q2, N = 1000)
print(data.obj2)


################################################################
# Example 4: print a fit object                           #
################################################################
set.seed(123)
Q2 <- sim.Q(3, 10)
fit.obj <- fit(Y = data.obj$dat, Q = Q, model = "GDINA")
print(fit.obj)


################################################################
# Example 5: print summary objects                             #
################################################################
summary.CDM.obj <- summary(CDM.obj)
print(summary.CDM.obj)

summary.val.obj <- summary(validation.obj)
print(summary.val.obj)

summary.sim.obj <- summary(data.obj2)
print(summary.sim.obj)

summary.fit <- summary(fit.obj)
print(summary.fit)
}

}
