% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_roc.R
\name{summarize_dataset}
\alias{summarize_dataset}
\title{Summarize classifiers performance in a dataset}
\usage{
summarize_dataset(
  data,
  predictors = NULL,
  response,
  ratio,
  threshold,
  .condition = NULL,
  .progress = FALSE
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{predictors}{A vector of numeric data variables which represents the
different classifiers or predictors in data to be summarized.

If \code{NULL}and by default, \code{predictors} will match all numeric variables in
\code{data} with the exception of \code{response}, given that it has a numeric type.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{ratio}{Ratio or axis where to apply calculations.
\itemize{
\item If \code{"tpr"}, only points within the specified region of TPR, y axis, will be
considered for calculations.
\item If \code{"fpr"}, only points within the specified region of FPR, x axis, will be
considered for calculations.
}}

\item{threshold}{A number between 0 and 1, both inclusive, which represents
the region bound where to calculate partial area under curve.

If \code{ratio = "tpr"}, it represents lower bound of the TPR region, being its
upper limit equal to 1.

If \code{ratio = "fpr"}, it represents the upper bound of the FPR region,
being its lower limit equal to 0.}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}

\item{.progress}{If \code{TRUE}, show progress of calculations.}
}
\value{
A list with different elements:
\itemize{
\item Performance metrics for each of evaluated classifiers.
\item Overall description of performance metrics in the dataset.
}
}
\description{
Calculate a series of metrics describing global and local
performance for selected classifiers in a dataset.
}
\examples{
summarize_dataset(iris, response = Species, ratio = "tpr", threshold = 0.9)
}
