% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmf2.R
\name{vmf2}
\alias{vmf2}
\alias{dvmf2}
\alias{rvmf2}
\title{Reparameterised von Mises-Fisher distribution}
\usage{
dvmf2(x, theta, log = FALSE)

rvmf2(n, theta)
}
\arguments{
\item{x}{unit vector or matrix (with each row being a unit vector) of evaluation points}

\item{theta}{direction and concentration vector. The direction of \code{theta} determines the mean direction on the sphere.
The norm of \code{theta} is the concentration parameter of the distribution.}

\item{log}{logical; if \code{TRUE}, densities are returned on the log scale.}

\item{n}{number of random values to return.}
}
\value{
\code{dvmf} gives the density and \code{rvm} generates random deviates.
}
\description{
Density, distribution function, and random generation for the von Mises-Fisher distribution.
}
\details{
In this parameterisation, \eqn{\theta = \kappa \mu}, where \eqn{\mu} is a unit vector and \eqn{\kappa} is the concentration parameter.

\code{dvmf2} allows for automatic differentiation with \code{RTMB}. \code{rvmf2} is imported from \code{movMF::rmovMF}.
}
\examples{
set.seed(123)
# single parameter set
theta <- c(1,2,3)
x <- rvmf2(1, theta)
d <- dvmf2(x, theta)

# vectorised over parameters
theta <- matrix(theta, nrow = 1)
theta <- theta[rep(1,10), ]
x <- rvmf2(10, theta)
d <- dvmf2(x, theta)
}
